/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.secrets.api;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import org.sonar.plugins.common.InputFileContext;
import org.sonar.plugins.secrets.api.AuxiliaryPatternMatcher;
import org.sonar.plugins.secrets.api.DistanceValidation;
import org.sonar.plugins.secrets.api.Match;
import org.sonar.plugins.secrets.api.PatternMatcher;
import org.sonar.plugins.secrets.configuration.model.matching.AuxiliaryPattern;
import org.sonar.plugins.secrets.configuration.model.matching.AuxiliaryPatternType;

public class AuxiliaryMatcher
implements AuxiliaryPatternMatcher {
    private static final int DEFAULT_MAX_LINE_LENGTH = 1000;
    private final AuxiliaryPattern auxiliaryPattern;
    private final PatternMatcher auxiliaryPatternMatcher;

    AuxiliaryMatcher(AuxiliaryPattern auxiliaryPattern, PatternMatcher auxiliaryPatternMatcher) {
        this.auxiliaryPattern = auxiliaryPattern;
        this.auxiliaryPatternMatcher = auxiliaryPatternMatcher;
    }

    public static AuxiliaryMatcher build(AuxiliaryPattern auxiliaryPattern) {
        return new AuxiliaryMatcher(auxiliaryPattern, PatternMatcher.build(auxiliaryPattern));
    }

    @Override
    public List<Match> filter(List<Match> candidateMatches, InputFileContext inputFileContext, String ruleId) {
        List<Match> auxiliaryMatches = this.auxiliaryPatternMatcher.findIn(inputFileContext.content(), ruleId);
        if (auxiliaryMatches.isEmpty()) {
            return new ArrayList<Match>();
        }
        BiPredicate<Match, Match> comparisonFunction = this.createComparisonFunction(inputFileContext);
        return AuxiliaryMatcher.filterBasedOnFunction(candidateMatches, auxiliaryMatches, comparisonFunction);
    }

    private BiPredicate<Match, Match> createComparisonFunction(InputFileContext inputFileContext) {
        BiPredicate<Match, Match> result = AuxiliaryPatternType.PATTERN_BEFORE == this.auxiliaryPattern.getType() ? DistanceValidation::isBefore : (AuxiliaryPatternType.PATTERN_AFTER == this.auxiliaryPattern.getType() ? DistanceValidation::isAfter : (auxMatch, candidateMatch) -> DistanceValidation.isBefore(auxMatch, candidateMatch) || DistanceValidation.isAfter(auxMatch, candidateMatch));
        if (this.auxiliaryPattern.getMaxCharacterDistance() != null) {
            result = result.and((? super T auxMatch, ? super U candidateMatch) -> DistanceValidation.inDistanceOf(auxMatch, candidateMatch, this.auxiliaryPattern.getMaxCharacterDistance()));
        }
        if (this.auxiliaryPattern.getMaxLineDistance() != null) {
            result = result.and(this.ignoringLongLines(inputFileContext)).and((? super T auxMatch, ? super U candidateMatch) -> {
                int auxMatchStartLine = inputFileContext.offsetToLineNumber(auxMatch.fileStartOffset());
                int auxMatchEndLine = inputFileContext.offsetToLineNumber(auxMatch.fileEndOffset());
                int candidateMatchStartLine = inputFileContext.offsetToLineNumber(candidateMatch.fileStartOffset());
                int candidateMatchEndLine = inputFileContext.offsetToLineNumber(candidateMatch.fileEndOffset());
                return DistanceValidation.inDistanceOf(auxMatchStartLine, auxMatchEndLine, candidateMatchStartLine, candidateMatchEndLine, this.auxiliaryPattern.getMaxLineDistance());
            });
        }
        return result;
    }

    private static List<Match> filterBasedOnFunction(List<Match> candidateMatches, List<Match> auxiliaryMatches, BiPredicate<Match, Match> comparisonFunction) {
        ArrayList<Match> filteredCandidates = new ArrayList<Match>();
        block0: for (Match regexMatch : candidateMatches) {
            for (Match auxiliaryMatch : auxiliaryMatches) {
                if (!comparisonFunction.test(auxiliaryMatch, regexMatch)) continue;
                filteredCandidates.add(regexMatch);
                continue block0;
            }
        }
        return filteredCandidates;
    }

    private BiPredicate<Match, Match> ignoringLongLines(InputFileContext inputFileContext) {
        int maxLineLength = this.auxiliaryPattern.getMaxLineLength() != null ? this.auxiliaryPattern.getMaxLineLength() : 1000;
        return (auxMatch, candidateMatch) -> {
            int startLine = inputFileContext.offsetToLineNumber(candidateMatch.fileStartOffset());
            int lineLength = inputFileContext.lines().get(startLine - 1).length();
            boolean isCandidateLineTooLong = lineLength >= maxLineLength;
            return !isCandidateLineTooLong;
        };
    }
}

