/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.secrets.api;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.plugins.common.InputFileContext;

public final class AutomaticTestFileFilter {
    private static final Logger LOG = LoggerFactory.getLogger(AutomaticTestFileFilter.class);

    private AutomaticTestFileFilter() {
    }

    public static Predicate<InputFileContext> isNotAutomaticallyDetectedTestFile() {
        return ctx -> !AutomaticTestFileFilter.isFilenameTest(ctx) && !AutomaticTestFileFilter.isFileInDocOrTestDirectory(ctx);
    }

    private static boolean isFilenameTest(InputFileContext inputFileContext) {
        String filename = inputFileContext.getInputFile().filename().toLowerCase(Locale.ROOT);
        return filename.startsWith("test") || filename.contains("test.") || filename.contains("tests.") || filename.endsWith(".spec.js") || filename.endsWith(".spec.jsx") || filename.endsWith(".spec.ts") || filename.endsWith(".spec.tsx");
    }

    private static boolean isFileInDocOrTestDirectory(InputFileContext inputFileContext) {
        String relativeUnixPath;
        Path path = Path.of(inputFileContext.getInputFile().uri());
        try {
            Path baseDir = inputFileContext.getFileSystem().baseDir().toPath();
            Path relativePath = baseDir.relativize(path).normalize();
            relativeUnixPath = AutomaticTestFileFilter.normalizeToUnixPathSeparator(relativePath.toString().toLowerCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            LOG.debug("Couldn't calculate the projects relative path of {}", (Object)inputFileContext.getInputFile());
            return false;
        }
        List<String> pathElements = Arrays.asList(relativeUnixPath.split("/"));
        List<String> pathElementsWithoutFilename = pathElements.subList(0, pathElements.size() - 1);
        return AutomaticTestFileFilter.isDocDirectory(pathElementsWithoutFilename) || AutomaticTestFileFilter.isTestDirectory(pathElementsWithoutFilename) || AutomaticTestFileFilter.hasEnding(pathElementsWithoutFilename, "test") || AutomaticTestFileFilter.hasEnding(pathElementsWithoutFilename, "tests");
    }

    private static String normalizeToUnixPathSeparator(String filename) {
        return filename.replace('\\', '/');
    }

    private static boolean isDocDirectory(List<String> pathElements) {
        return pathElements.contains("doc") || pathElements.contains("docs");
    }

    private static boolean isTestDirectory(List<String> pathElements) {
        return pathElements.contains("test") || pathElements.contains("tests") || pathElements.contains("mock") || pathElements.contains("mocks");
    }

    private static boolean hasEnding(List<String> pathElements, String text) {
        return pathElements.stream().anyMatch(pathElement -> pathElement.endsWith(text));
    }
}

