/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.secrets.api;

import java.util.List;
import java.util.function.Predicate;
import org.sonar.plugins.common.Check;
import org.sonar.plugins.common.InputFileContext;
import org.sonar.plugins.common.measures.DurationStatistics;
import org.sonar.plugins.secrets.api.Matcher;
import org.sonar.plugins.secrets.api.SpecificationConfiguration;
import org.sonar.plugins.secrets.api.SpecificationLoader;

public abstract class AbstractSpecificationBasedCheck<L extends SpecificationLoader, M extends Matcher>
extends Check {
    protected List<M> matchers;
    protected DurationStatistics durationStatistics;

    protected AbstractSpecificationBasedCheck() {
    }

    public void initialize(L loader, DurationStatistics durationStatistics, SpecificationConfiguration specificationConfiguration) {
        this.durationStatistics = durationStatistics;
        String ruleId = this.getRuleKey().rule();
        this.matchers = this.initializeMatchers(loader, ruleId, specificationConfiguration);
    }

    @Override
    public void analyze(InputFileContext ctx) {
        this.analyze(ctx, (String checkId) -> true);
    }

    public void analyze(InputFileContext ctx, String ruleId) {
        this.analyze(ctx, (String checkId) -> checkId.equals(ruleId));
    }

    protected abstract void analyze(InputFileContext var1, Predicate<String> var2);

    protected abstract List<M> initializeMatchers(L var1, String var2, SpecificationConfiguration var3);
}

