/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.common.thread;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelizationManager {
    private static final Logger LOG = LoggerFactory.getLogger(ParallelizationManager.class);
    private static final int SEMAPHORE_ACQUIRE_TIMEOUT = 100;
    private final int threads;
    private final ExecutorService executorService;
    private final Semaphore semaphore;
    private final AtomicReference<Exception> exception = new AtomicReference();

    public ParallelizationManager(int threads) {
        this.threads = threads;
        this.executorService = Executors.newFixedThreadPool(threads);
        this.semaphore = new Semaphore(threads);
    }

    public void submit(Runnable runnable) {
        if (this.executorService.isShutdown()) {
            throw new RejectedExecutionException();
        }
        try {
            boolean acquired;
            do {
                acquired = this.semaphore.tryAcquire(100L, TimeUnit.MILLISECONDS);
                this.propagatePossibleException();
            } while (!acquired);
            this.executorService.execute(() -> {
                try {
                    runnable.run();
                    this.semaphore.release();
                }
                catch (Exception e) {
                    LOG.warn("Exception in thread " + Thread.currentThread().getName(), e);
                    this.exception.getAndSet(e);
                }
            });
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void drainThreads() {
        try {
            boolean acquired;
            do {
                acquired = this.semaphore.tryAcquire(this.threads, 100L, TimeUnit.MILLISECONDS);
                this.propagatePossibleException();
            } while (!acquired);
            this.semaphore.release(this.threads);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void shutdown() {
        this.executorService.shutdown();
        try {
            this.executorService.awaitTermination(1L, TimeUnit.HOURS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.propagatePossibleException();
    }

    private void propagatePossibleException() {
        Throwable e = this.exception.getAndSet(null);
        if (e != null) {
            if (e instanceof IllegalStateException) {
                IllegalStateException illegalStateException = (IllegalStateException)e;
                throw illegalStateException;
            }
            throw new IllegalStateException(e);
        }
    }
}

