/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.common.measures;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.utils.Version;

public class TelemetryReporter {
    public static final String KEY_PREFIX = "text.";
    private static final Version TELEMETRY_SUPPORTED_API_VERSION = Version.create((int)10, (int)9);
    private final SensorContext sensorContext;
    private final Map<String, Integer> numericMeasures;
    private long startRecordingTimeMs;

    public TelemetryReporter(SensorContext sensorContext) {
        this.sensorContext = sensorContext;
        this.numericMeasures = new HashMap<String, Integer>();
    }

    public void startRecordingSensorTime() {
        this.startRecordingTimeMs = System.currentTimeMillis();
    }

    public void endRecordingSensorTime(String suffix) {
        long endRecordingTimeMs = System.currentTimeMillis();
        long durationMs = endRecordingTimeMs - this.startRecordingTimeMs;
        String key = "sensor_time_ms_" + suffix.toLowerCase(Locale.ROOT);
        this.addNumericMeasure(key, (int)durationMs);
    }

    public TelemetryReporter addNumericMeasure(String key, int value) {
        if (value < 0) {
            return this;
        }
        key = KEY_PREFIX + (String)key;
        this.numericMeasures.merge((String)key, value, Integer::sum);
        return this;
    }

    public void report() {
        boolean isTelemetrySupported = this.sensorContext.runtime().getApiVersion().isGreaterThanOrEqual(TELEMETRY_SUPPORTED_API_VERSION);
        if (isTelemetrySupported) {
            this.numericMeasures.forEach((key, numericValue) -> this.sensorContext.addTelemetryProperty(key, numericValue.toString()));
        }
    }
}

