/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.common.measures;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.config.Configuration;

public final class MemoryMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(MemoryMonitor.class);
    private static final String PROPERTY_KEY = "sonar.text.duration.statistics";
    private final boolean recordingEnabled;
    final List<MemoryRecord> memoryRecords = new ArrayList<MemoryRecord>();
    private long overallPeak;
    private final NumberFormat format;

    public MemoryMonitor(Configuration config) {
        this.recordingEnabled = config.getBoolean(PROPERTY_KEY).orElse(false) != false && LOG.isInfoEnabled();
        MemoryMonitor.resetPeak();
        this.addRecord("Initial memory");
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.ROOT);
        symbols.setGroupingSeparator('\'');
        this.format = new DecimalFormat("#,###", symbols);
    }

    public void addRecord(String name) {
        if (this.recordingEnabled) {
            this.memoryRecords.add(new MemoryRecord(name, MemoryMonitor.getMemoryUsedInMB(), this.getPeakMemoryUsedInMB()));
            MemoryMonitor.resetPeak();
        }
    }

    public void logMemory() {
        if (!this.recordingEnabled) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Text and Secrets memory statistics (used, peak):");
        sb.append(System.lineSeparator());
        for (MemoryRecord memoryRecord : this.memoryRecords) {
            sb.append(memoryRecord.toFormattedString(this.format)).append(System.lineSeparator());
        }
        sb.append("Sensor peak memory: ");
        sb.append(this.format.format(this.overallPeak));
        sb.append("MB");
        sb.append(System.lineSeparator());
        sb.append("Note that these values may not be accurate due to garbage collection; they should only be used to detect significant outliers.");
        LOG.info(sb.toString());
        this.logAvailableMemory(ManagementFactory.getOperatingSystemMXBean());
    }

    private static long toMB(long value) {
        return value / 0x100000L;
    }

    private static long getAvailableSystemMemoryInMB(java.lang.management.OperatingSystemMXBean operatingSystemMXBean) throws NoSuchMethodError, ClassCastException {
        OperatingSystemMXBean os = (OperatingSystemMXBean)operatingSystemMXBean;
        return MemoryMonitor.toMB(os.getTotalMemorySize());
    }

    private static long getAvailableRuntimeMemory() {
        return MemoryMonitor.toMB(Runtime.getRuntime().maxMemory());
    }

    private String getAvailableRuntimeMemoryInMB() {
        long runtimeMemory = MemoryMonitor.getAvailableRuntimeMemory();
        if (runtimeMemory == Long.MAX_VALUE) {
            return "unlimited";
        }
        return this.format.format(runtimeMemory) + "MB";
    }

    void logAvailableMemory(java.lang.management.OperatingSystemMXBean operatingSystemMXBean) {
        if (!this.recordingEnabled) {
            return;
        }
        try {
            LOG.info("Total system memory: {}, available runtime memory: {}", (Object)(this.format.format(MemoryMonitor.getAvailableSystemMemoryInMB(operatingSystemMXBean)) + "MB"), (Object)this.getAvailableRuntimeMemoryInMB());
        }
        catch (ClassCastException | NoSuchMethodError e) {
            LOG.info("Could not get total system memory: {}", (Object)e.getMessage());
        }
    }

    private static long getMemoryUsedInMB() {
        return MemoryMonitor.toMB(ManagementFactory.getMemoryPoolMXBeans().stream().filter(p -> p.getType() == MemoryType.HEAP).mapToLong(p -> p.getUsage().getUsed()).sum());
    }

    private long getPeakMemoryUsedInMB() {
        long currentPeak = MemoryMonitor.toMB(ManagementFactory.getMemoryPoolMXBeans().stream().filter(p -> p.getType() == MemoryType.HEAP).mapToLong(p -> p.getPeakUsage().getUsed()).sum());
        this.overallPeak = Math.max(this.overallPeak, currentPeak);
        return currentPeak;
    }

    private static void resetPeak() {
        ManagementFactory.getMemoryPoolMXBeans().stream().filter(p -> p.getType() == MemoryType.HEAP).forEach(MemoryPoolMXBean::resetPeakUsage);
    }

    record MemoryRecord(String name, long used, long peak) {
        public String toFormattedString(Format format) {
            return this.name + ": " + format.format(this.used) + "MB, " + format.format(this.peak) + "MB";
        }
    }
}

