/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.common.measures;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.config.Configuration;

public class DurationStatistics {
    private static final Logger LOG = LoggerFactory.getLogger(DurationStatistics.class);
    private static final String PROPERTY_KEY = "sonar.text.duration.statistics";
    public static final String SUFFIX_GENERAL = "::general";
    public static final String SUFFIX_TOTAL = "::total";
    public static final String SUFFIX_PRE = "::preFilter";
    public static final String SUFFIX_MATCHER = "::matcher";
    public static final String SUFFIX_POST = "::postFilter";
    private final Map<String, Measurement> stats = new ConcurrentHashMap<String, Measurement>();
    private final AtomicBoolean isRecordingEnabled = new AtomicBoolean(false);
    private final NumberFormat format;

    public DurationStatistics(Configuration config) {
        config.getBoolean(PROPERTY_KEY).ifPresent(this.isRecordingEnabled::set);
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.ROOT);
        symbols.setGroupingSeparator('\'');
        this.format = new DecimalFormat("#,###", symbols);
    }

    public boolean isRecordingEnabled() {
        return this.isRecordingEnabled.get();
    }

    public void timed(String id, Runnable runnable) {
        this.timed(id, () -> {
            runnable.run();
            return null;
        });
    }

    public <T> T timed(String id, Supplier<T> supplier) {
        if (this.isRecordingEnabled.get()) {
            long startTime = System.nanoTime();
            T result = supplier.get();
            this.addRecord(id, System.nanoTime() - startTime);
            return result;
        }
        return supplier.get();
    }

    void addRecord(String id, long elapsedTime) {
        this.stats.computeIfAbsent(id, key -> new Measurement()).add(elapsedTime);
    }

    public void log() {
        if (this.isRecordingEnabled.get()) {
            this.calculateSecretMatcherTotals();
            StringBuilder sbGeneral = new StringBuilder("Duration Statistics").append(System.lineSeparator()).append((CharSequence)DurationStatistics.formatEntries(this.format, this.stats.entrySet().stream().filter(s -> ((String)s.getKey()).endsWith(SUFFIX_GENERAL))));
            LOG.info("{}", (Object)sbGeneral);
            if (!LOG.isDebugEnabled()) {
                return;
            }
            StringBuilder sbMatcher = new StringBuilder("Secret Matcher Duration Statistics").append(System.lineSeparator()).append((CharSequence)DurationStatistics.formatEntries(this.format, this.stats.entrySet().stream().filter(s -> ((String)s.getKey()).endsWith(SUFFIX_TOTAL))));
            LOG.debug("{}", (Object)sbMatcher);
            StringBuilder sbMatcherVerbose = new StringBuilder("Granular Secret Matcher Duration Statistics").append(System.lineSeparator()).append((CharSequence)DurationStatistics.formatEntries(this.format, this.stats.entrySet().stream().filter(s -> !((String)s.getKey()).endsWith(SUFFIX_TOTAL) && !((String)s.getKey()).endsWith(SUFFIX_GENERAL))));
            LOG.debug("{}", (Object)sbMatcherVerbose);
        }
    }

    private void calculateSecretMatcherTotals() {
        for (Map.Entry<String, Measurement> entry : Collections.unmodifiableSet(this.stats.entrySet())) {
            if (entry.getKey().endsWith(SUFFIX_PRE)) {
                this.addRecord("preFilter::general", entry.getValue().total.get());
                continue;
            }
            if (entry.getKey().endsWith(SUFFIX_MATCHER)) {
                this.addRecord("matcher::general", entry.getValue().total.get());
                continue;
            }
            if (!entry.getKey().endsWith(SUFFIX_POST)) continue;
            this.addRecord("postFilter::general", entry.getValue().total.get());
        }
    }

    private static StringBuilder formatEntries(Format format, Stream<Map.Entry<String, Measurement>> entries) {
        StringBuilder sb = new StringBuilder();
        entries.sorted(Comparator.comparingLong(entry -> ((Measurement)entry.getValue()).total.get()).reversed()).forEach(e -> sb.append((CharSequence)DurationStatistics.formatEntry(format, (String)e.getKey(), (Measurement)e.getValue())));
        return sb;
    }

    private static StringBuilder formatEntry(Format format, String id, Measurement measurement) {
        long totalMs = measurement.total.get() / 1000000L;
        long count = measurement.count.get();
        double meanMs = (double)totalMs * 1.0 / (double)count * 1000.0;
        return new StringBuilder("  ").append(id).append(" ").append(format.format(totalMs)).append(" ms ").append(measurement.count.get()).append(" times (mean ").append(format.format(meanMs)).append(" us)").append(System.lineSeparator());
    }

    private static class Measurement {
        private final AtomicLong count = new AtomicLong();
        private final AtomicLong total = new AtomicLong();

        private Measurement() {
        }

        public void add(long delta) {
            this.count.incrementAndGet();
            this.total.addAndGet(delta);
        }
    }
}

