/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.common.measures;

import java.util.Map;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.plugins.common.TextAndSecretsSensor;
import org.sonar.plugins.common.measures.TelemetryReporter;

public class CiVendorFilesTelemetry {
    private static final String TELEMETRY_INFIX = "civendor_";
    public static final Map<String, String> CI_VENDOR_TO_REL_FILE_PATH = Map.of("travisci", ".travis.yml", "jenkins", "Jenkinsfile", "circleci", ".circleci/config.yml", "gitlab", ".gitlab-ci.yml", "appveyor", "appveyor.yml", "azurepipelines", "azure-pipelines.yml", "bamboo", "bamboo.yml", "buildkite", ".buildkite/pipeline.yml", "bitbucketpipelines", "bitbucket-pipelines.yml", "semaphore", ".semaphore/semaphore.yml");

    private CiVendorFilesTelemetry() {
    }

    public static void measureProjectsCIFilesInclusion(SensorContext sensorContext, TelemetryReporter telemetryReporter) {
        if (TextAndSecretsSensor.isSonarLintContext(sensorContext.runtime())) {
            return;
        }
        FileSystem fileSystem = sensorContext.fileSystem();
        for (Map.Entry<String, String> stringStringEntry : CI_VENDOR_TO_REL_FILE_PATH.entrySet()) {
            String vendor = stringStringEntry.getKey();
            String relativePath = stringStringEntry.getValue();
            FilePredicate filePredicate = fileSystem.predicates().hasRelativePath(relativePath);
            boolean hasFilesForVendor = fileSystem.hasFiles(filePredicate);
            telemetryReporter.addNumericMeasure(TELEMETRY_INFIX + vendor, hasFilesForVendor ? 1 : 0);
        }
    }
}

