/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.common.git.utils;

import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Scanner;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessBuilderWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessBuilderWrapper.class);
    private static final long TIMEOUT_MILLIS = 30000L;
    private final ExecutorService processMonitor = Executors.newSingleThreadExecutor();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status execute(List<String> command, Consumer<String> lineConsumer) throws IOException {
        Process process = this.startProcess(command);
        Future<?> readerFuture = this.processMonitor.submit(() -> {
            String message = "Read the \"%s\" stdout in thread \"%s\"".formatted(String.join((CharSequence)" ", command), Thread.currentThread().getName());
            LOG.debug(message);
            ProcessBuilderWrapper.readProcessOutput(process, lineConsumer);
        });
        try {
            boolean exited = process.waitFor(30000L, TimeUnit.MILLISECONDS);
            if (!exited) {
                LOG.debug("Process {} did not exit within {} ms", (Object)command, (Object)30000L);
                Status status = Status.FAILURE;
                return status;
            }
            if (process.exitValue() != 0) {
                LOG.debug("Process {} exited with code {}", (Object)command, (Object)process.exitValue());
                Status status = Status.FAILURE;
                return status;
            }
            readerFuture.get();
            Status status = Status.SUCCESS;
            return status;
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.debug("Error while executing process {}", (Object)command, (Object)e);
            Status status = Status.FAILURE;
            return status;
        }
        finally {
            process.destroy();
        }
    }

    Process startProcess(List<String> command) throws IOException {
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        return processBuilder.start();
    }

    public void shutdown() {
        this.processMonitor.shutdownNow();
    }

    private static void readProcessOutput(Process process, Consumer<String> lineConsumer) {
        try (Scanner scanner = new Scanner(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
            while (scanner.hasNextLine()) {
                lineConsumer.accept(scanner.nextLine());
            }
        }
    }

    public static enum Status {
        SUCCESS,
        FAILURE;

    }
}

