/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.common.git;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.plugins.common.git.GitService;

public final class NullGitService
extends GitService {
    public static final NullGitService INSTANCE = new NullGitService();
    private static final Logger LOG = LoggerFactory.getLogger(NullGitService.class);

    private NullGitService() {
    }

    @Override
    public GitService.DirtyFileNamesResult retrieveDirtyFileNames() {
        NullGitService.logServiceNotInitialized();
        return GitService.DirtyFileNamesResult.UNSUCCESSFUL;
    }

    @Override
    public GitService.RepositoryMetadataResult retrieveRepositoryMetadata() {
        NullGitService.logServiceNotInitialized();
        return GitService.RepositoryMetadataResult.UNSUCCESSFUL;
    }

    private static void logServiceNotInitialized() {
        LOG.debug("Git service has not been initialized, returning unsuccessful result");
    }

    @Override
    public void close() {
    }
}

