/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.common.git;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.sonar.plugins.common.git.GitService;

public class LazyGitService
extends GitService {
    private final Supplier<GitService> serviceSupplier;
    @Nullable
    private GitService serviceInstance;

    public LazyGitService(Supplier<GitService> serviceSupplier) {
        this.serviceSupplier = serviceSupplier;
    }

    @Override
    public GitService.DirtyFileNamesResult retrieveDirtyFileNames() {
        return this.getService().retrieveDirtyFileNames();
    }

    @Override
    public GitService.RepositoryMetadataResult retrieveRepositoryMetadata() {
        return this.getService().retrieveRepositoryMetadata();
    }

    private GitService getService() {
        if (this.serviceInstance == null) {
            this.serviceInstance = this.serviceSupplier.get();
        }
        return this.serviceInstance;
    }

    @Override
    public void close() throws Exception {
        if (this.serviceInstance != null) {
            this.serviceInstance.close();
        }
    }
}

