/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.common.git;

import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.plugins.common.git.GitService;
import org.sonar.plugins.common.git.JGitSupplier;

public class JGitService
extends GitService {
    private static final Logger LOG = LoggerFactory.getLogger(JGitService.class);
    private final Path baseDir;
    private final JGitSupplier jGitSupplier;

    public JGitService(Path baseDir) {
        this(baseDir, new JGitSupplier());
    }

    JGitService(Path baseDir, JGitSupplier jGitSupplier) {
        this.baseDir = baseDir;
        this.jGitSupplier = jGitSupplier;
    }

    @Override
    public GitService.DirtyFileNamesResult retrieveDirtyFileNames() {
        Git git = this.jGitSupplier.getGit(this.baseDir);
        try {
            Status status = git.status().call();
            HashSet<String> dirtyFiles = new HashSet<String>();
            dirtyFiles.addAll(status.getUntracked());
            dirtyFiles.addAll(status.getModified());
            dirtyFiles.addAll(status.getChanged());
            GitService.DirtyFileNamesResult dirtyFileNamesResult = new GitService.DirtyFileNamesResult(true, dirtyFiles);
            if (git != null) {
                git.close();
            }
            return dirtyFileNamesResult;
        }
        catch (Throwable throwable) {
            try {
                if (git != null) {
                    try {
                        git.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (GitAPIException | JGitSupplier.JGitInitializationException e) {
                LOG.debug("Exception querying Git data: {}", (Object)e.getMessage());
                return GitService.DirtyFileNamesResult.UNSUCCESSFUL;
            }
        }
    }

    @Override
    public GitService.RepositoryMetadataResult retrieveRepositoryMetadata() {
        List<RemoteConfig> remotes = this.getRemotes();
        if (remotes.isEmpty()) {
            return GitService.RepositoryMetadataResult.UNSUCCESSFUL;
        }
        List<URIish> defaultRemoteURIs = remotes.get(0).getURIs();
        if (defaultRemoteURIs.isEmpty()) {
            return GitService.RepositoryMetadataResult.UNSUCCESSFUL;
        }
        String defaultRemoteUri = defaultRemoteURIs.get(0).getRawPath();
        return JGitService.parseRepositoryMetadataFromRemoteUri(defaultRemoteUri);
    }

    List<RemoteConfig> getRemotes() {
        Git git = this.jGitSupplier.getGit(this.baseDir);
        try {
            Object object = git.remoteList().call();
            if (git != null) {
                git.close();
            }
            return object;
        }
        catch (Throwable throwable) {
            try {
                if (git != null) {
                    try {
                        git.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (GitAPIException | JGitSupplier.JGitInitializationException e) {
                LOG.debug("Exception querying Git data: {}", (Object)e.getMessage());
                return List.of();
            }
        }
    }

    @Override
    public void close() {
    }
}

