/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.common.git;

import java.io.File;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.plugins.common.git.GitService;

public class GitTrackedFilePredicate
implements FilePredicate {
    private static final Logger LOG = LoggerFactory.getLogger(GitTrackedFilePredicate.class);
    private final Set<String> ignoredFileNames = new HashSet<String>();
    private final Set<String> dirtyFileNames;
    private final boolean isGitStatusSuccessful;
    private final Path projectRootPath;
    private final FilePredicate defaultFilePredicate;

    public GitTrackedFilePredicate(Path baseDir, GitService gitService, FilePredicate defaultFilePredicate) {
        GitService.DirtyFileNamesResult gitResult = gitService.retrieveDirtyFileNames();
        this.dirtyFileNames = gitResult.dirtyFileNames();
        this.isGitStatusSuccessful = gitResult.isGitSuccessful();
        this.projectRootPath = baseDir;
        if (!this.isGitStatusSuccessful) {
            LOG.debug("Unable to retrieve git status");
        }
        this.defaultFilePredicate = defaultFilePredicate;
    }

    public boolean apply(InputFile inputFile) {
        boolean result;
        String relativePath;
        if (!this.isGitStatusSuccessful) {
            return true;
        }
        Path filePath = Path.of(inputFile.uri()).toAbsolutePath();
        if (filePath.toString().contains(File.separator + ".git" + File.separator)) {
            return false;
        }
        try {
            relativePath = this.projectRootPath.relativize(filePath).toString();
        }
        catch (IllegalArgumentException e) {
            LOG.debug("Unable to resolve git status for {}, falling back to analyzing the file if it's associated with a language", (Object)inputFile, (Object)e);
            return this.defaultFilePredicate.apply(inputFile);
        }
        boolean bl = result = !this.dirtyFileNames.contains(relativePath);
        if (!result) {
            this.ignoredFileNames.add(relativePath);
        }
        return result;
    }

    public boolean isGitStatusSuccessful() {
        return this.isGitStatusSuccessful;
    }

    public void logSummary() {
        int numberOfIgnoredFiles = this.ignoredFileNames.size();
        if (numberOfIgnoredFiles > 0) {
            if (numberOfIgnoredFiles == 1) {
                LOG.info("1 file is ignored because it is untracked by git or has been modified");
            } else {
                LOG.info("{} files are ignored because they are untracked by git or has been modified", (Object)numberOfIgnoredFiles);
            }
            String fileList = this.ignoredFileNames.stream().sorted().collect(Collectors.joining("\n\t"));
            LOG.debug("Files untracked by git or modified:\n\t{}", (Object)fileList);
        }
    }
}

