/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.common.git;

import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GitService
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(GitService.class);

    public abstract DirtyFileNamesResult retrieveDirtyFileNames();

    public abstract RepositoryMetadataResult retrieveRepositoryMetadata();

    protected static RepositoryMetadataResult parseRepositoryMetadataFromRemoteUri(String remoteUri) {
        try {
            String[] remoteUriParts = remoteUri.split("[/:]");
            String repositoryName = remoteUriParts[remoteUriParts.length - 1];
            int extensionIndex = repositoryName.lastIndexOf(46);
            if (extensionIndex != -1) {
                repositoryName = repositoryName.substring(0, extensionIndex);
            }
            String organizationName = remoteUriParts[remoteUriParts.length - 2];
            if (repositoryName.isEmpty() || organizationName.isEmpty()) {
                LOG.debug("Failed to parse repository metadata from remote '{}'", (Object)remoteUri);
                return RepositoryMetadataResult.UNSUCCESSFUL;
            }
            return new RepositoryMetadataResult(true, repositoryName, organizationName);
        }
        catch (Exception e) {
            LOG.debug("Failed to parse repository metadata from remote '{}': {}", (Object)remoteUri, (Object)e.getMessage());
            return RepositoryMetadataResult.UNSUCCESSFUL;
        }
    }

    public record RepositoryMetadataResult(boolean isGitSuccessful, String projectName, String organizationName) {
        public static final RepositoryMetadataResult UNSUCCESSFUL = new RepositoryMetadataResult(false, "", "");
    }

    public record DirtyFileNamesResult(boolean isGitSuccessful, Set<String> dirtyFileNames) {
        public static final DirtyFileNamesResult UNSUCCESSFUL = new DirtyFileNamesResult(false, Set.of());
    }
}

