/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.common.git;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.plugins.common.git.GitService;
import org.sonar.plugins.common.git.utils.ProcessBuilderWrapper;

public final class GitCliService
extends GitService {
    private static final Logger LOG = LoggerFactory.getLogger(GitCliService.class);
    private static final String GIT_PORCELAIN_UNTRACKED_MARKER = "??";
    private static final String GIT_PORCELAIN_MODIFIED_UNSTAGED_MARKER = " M";
    private static final String GIT_PORCELAIN_MODIFIED_STAGED_MARKER = "M ";
    private static final String GIT_PORCELAIN_MODIFIED_BOTH_MARKER = "MM";
    private static final int GIT_PORCELAIN_MARKER_LENGTH = 2;
    private static final String WHERE_EXE_LOCATION = System.getenv("systemroot") + "\\System32\\where.exe";
    private String gitCommand = "git";
    private boolean available = false;
    private final Path baseDir;
    private final ProcessBuilderWrapper processBuilderWrapper;

    private GitCliService(Path baseDir, ProcessBuilderWrapper processBuilderWrapper) {
        this.baseDir = baseDir;
        this.processBuilderWrapper = processBuilderWrapper;
    }

    public static GitCliService createOsSpecificInstance(Path baseDir) {
        return GitCliService.createOsSpecificInstance(baseDir, new ProcessBuilderWrapper());
    }

    static GitCliService createOsSpecificInstance(Path baseDir, ProcessBuilderWrapper processBuilderWrapper) {
        GitCliService instance = new GitCliService(baseDir, processBuilderWrapper);
        try {
            if (GitCliService.isWindows()) {
                String windowsGitCommand = instance.locateGitOnWindows();
                instance.gitCommand = Objects.requireNonNullElse(windowsGitCommand, instance.gitCommand);
            }
        }
        catch (IOException e) {
            LOG.debug("Failed to locate Git on Windows: {}", (Object)e.getMessage());
        }
        try {
            List<String> gitVersionCommand = List.of(instance.gitCommand, "--version");
            ProcessBuilderWrapper.Status status = instance.execute(gitVersionCommand, line -> LOG.debug("git --version returned: {}", line));
            instance.available = status == ProcessBuilderWrapper.Status.SUCCESS;
        }
        catch (IOException e) {
            LOG.debug("Not using Git CLI, `git --version` failed: {}", (Object)e.getMessage());
        }
        return instance;
    }

    @Override
    public GitService.DirtyFileNamesResult retrieveDirtyFileNames() {
        if (!this.available) {
            return GitService.DirtyFileNamesResult.UNSUCCESSFUL;
        }
        ConcurrentHashMap.KeySetView dirtyFiles = ConcurrentHashMap.newKeySet();
        try {
            List<String> statusCommand = List.of(this.gitCommand, "-C", this.baseDir.toAbsolutePath().toString(), "status", "--untracked-files=all", "--porcelain");
            ProcessBuilderWrapper.Status status = this.execute(statusCommand, line -> {
                if (GitCliService.hasDirtyFileMarker(line)) {
                    dirtyFiles.add(line.substring(2).trim());
                }
            });
            if (status != ProcessBuilderWrapper.Status.SUCCESS) {
                return GitService.DirtyFileNamesResult.UNSUCCESSFUL;
            }
        }
        catch (IOException e) {
            return GitService.DirtyFileNamesResult.UNSUCCESSFUL;
        }
        return new GitService.DirtyFileNamesResult(true, dirtyFiles);
    }

    private static boolean hasDirtyFileMarker(String porcelainLine) {
        return porcelainLine.startsWith(GIT_PORCELAIN_UNTRACKED_MARKER) || porcelainLine.startsWith(GIT_PORCELAIN_MODIFIED_UNSTAGED_MARKER) || porcelainLine.startsWith(GIT_PORCELAIN_MODIFIED_STAGED_MARKER) || porcelainLine.startsWith(GIT_PORCELAIN_MODIFIED_BOTH_MARKER);
    }

    @Override
    public GitService.RepositoryMetadataResult retrieveRepositoryMetadata() {
        if (!this.available) {
            return GitService.RepositoryMetadataResult.UNSUCCESSFUL;
        }
        List<String> remotes = this.getGitRemotes();
        if (remotes.isEmpty()) {
            return GitService.RepositoryMetadataResult.UNSUCCESSFUL;
        }
        String defaultRemote = remotes.get(0);
        return GitCliService.parseRepositoryMetadata(defaultRemote);
    }

    List<String> getGitRemotes() {
        ArrayList<String> remotes = new ArrayList<String>();
        try {
            List<String> listRemotesCommand = List.of(this.gitCommand, "-C", this.baseDir.toAbsolutePath().toString(), "remote", "-v");
            ProcessBuilderWrapper.Status status = this.execute(listRemotesCommand, remotes::add);
            if (status != ProcessBuilderWrapper.Status.SUCCESS) {
                return List.of();
            }
        }
        catch (IOException e) {
            return List.of();
        }
        return remotes;
    }

    private static GitService.RepositoryMetadataResult parseRepositoryMetadata(String remote) {
        try {
            String remoteUrl = remote.split("\\s+")[1];
            return GitCliService.parseRepositoryMetadataFromRemoteUri(remoteUrl);
        }
        catch (Exception e) {
            LOG.debug("Failed to parse repository metadata from remote '{}': {}", (Object)remote, (Object)e.getMessage());
            return GitService.RepositoryMetadataResult.UNSUCCESSFUL;
        }
    }

    public boolean isAvailable() {
        return this.available;
    }

    String getGitCommand() {
        return this.gitCommand;
    }

    String locateGitOnWindows() throws IOException {
        LinkedList whereResultLines = new LinkedList();
        String gitExecutableName = "git.exe";
        this.execute(List.of(WHERE_EXE_LOCATION, "$PATH:" + gitExecutableName), whereResultLines::add);
        if (!whereResultLines.isEmpty()) {
            String whereResult = ((String)whereResultLines.get(0)).trim();
            LOG.debug("Found {} at {}", (Object)gitExecutableName, (Object)whereResult);
            return whereResult;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} not found in PATH. PATH value was: {}", (Object)gitExecutableName, (Object)System.getenv("PATH"));
        }
        return null;
    }

    ProcessBuilderWrapper.Status execute(List<String> command, Consumer<String> lineConsumer) throws IOException {
        return this.processBuilderWrapper.execute(command, lineConsumer);
    }

    static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("windows");
    }

    @Override
    public void close() {
        this.processBuilderWrapper.shutdown();
    }
}

