/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.common.git;

import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.plugins.common.git.GitCliService;
import org.sonar.plugins.common.git.GitService;
import org.sonar.plugins.common.git.JGitService;

public class GitCliAndJGitService
extends GitService {
    private static final Logger LOG = LoggerFactory.getLogger(GitCliAndJGitService.class);
    private final GitCliService gitCliService;
    private final JGitService jGitService;

    public GitCliAndJGitService(Path baseDir) {
        this(GitCliService.createOsSpecificInstance(baseDir), new JGitService(baseDir));
    }

    GitCliAndJGitService(GitCliService gitCliService, JGitService jGitService) {
        this.gitCliService = gitCliService;
        this.jGitService = jGitService;
    }

    @Override
    public GitService.DirtyFileNamesResult retrieveDirtyFileNames() {
        if (this.gitCliService.isAvailable()) {
            LOG.info("Using Git CLI to retrieve dirty files");
            return this.gitCliService.retrieveDirtyFileNames();
        }
        LOG.info("Using JGit to retrieve dirty files");
        return this.jGitService.retrieveDirtyFileNames();
    }

    @Override
    public GitService.RepositoryMetadataResult retrieveRepositoryMetadata() {
        if (this.gitCliService.isAvailable()) {
            LOG.info("Using Git CLI to retrieve repository metadata");
            return this.gitCliService.retrieveRepositoryMetadata();
        }
        LOG.info("Using JGit to retrieve repository metadata");
        return this.jGitService.retrieveRepositoryMetadata();
    }

    @Override
    public void close() {
        this.gitCliService.close();
        this.jGitService.close();
    }
}

