/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.common.analyzer;

import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.plugins.common.Check;
import org.sonar.plugins.common.InputFileContext;
import org.sonar.plugins.common.analyzer.Analyzer;
import org.sonar.plugins.common.measures.DurationStatistics;
import org.sonar.plugins.common.measures.MemoryMonitor;
import org.sonar.plugins.common.measures.TelemetryReporter;
import org.sonar.plugins.common.thread.ParallelizationManager;
import org.sonar.plugins.secrets.AbstractBinaryFileCheck;
import org.sonar.plugins.secrets.utils.CheckContainer;

public final class TextAndSecretsAnalyzer
extends Analyzer {
    private static final Logger LOG = LoggerFactory.getLogger(TextAndSecretsAnalyzer.class);
    private static final String ANALYSIS_NAME = "text and secrets analysis";
    private final CheckContainer checkContainer;

    public TextAndSecretsAnalyzer(SensorContext sensorContext, ParallelizationManager parallelizationManager, DurationStatistics durationStatistics, List<Check> suitableChecks, TelemetryReporter telemetryReporter, MemoryMonitor memoryMonitor, CheckContainer checkContainer) {
        super(sensorContext, parallelizationManager, durationStatistics, suitableChecks, ANALYSIS_NAME, telemetryReporter, memoryMonitor);
        this.checkContainer = checkContainer;
    }

    @Override
    protected boolean shouldAnalyzeFile(InputFileContext inputFileContext) {
        return TextAndSecretsAnalyzer.containsNoBinaryCharacters(inputFileContext);
    }

    @Override
    protected void analyzeAllChecks(InputFileContext inputFileContext) {
        try {
            this.checkContainer.analyze(inputFileContext);
        }
        catch (RuntimeException e) {
            this.logAnalysisError(inputFileContext.getInputFile(), e);
        }
    }

    private static boolean containsNoBinaryCharacters(InputFileContext inputFileContext) {
        boolean hasNonTextCharacters = inputFileContext.hasNonTextCharacters();
        if (hasNonTextCharacters) {
            LOG.warn("The file '{}' contains binary data and will not be included in the text and secrets analysis.", (Object)inputFileContext.getInputFile());
            if (inputFileContext.getInputFile().language() != null) {
                LOG.warn("Please check this file and/or exclude it from the analysis with sonar.exclusions property.");
            } else {
                LOG.warn("Please check this file and/or remove the extension from the '{}' property.", (Object)"sonar.text.inclusions");
            }
        }
        return !hasNonTextCharacters;
    }

    public static List<Check> filterSuitableChecks(Collection<Check> checks) {
        return checks.stream().filter(check -> !(check instanceof AbstractBinaryFileCheck)).toList();
    }
}

