/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.common.analyzer;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.CheckForNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.utils.Version;
import org.sonar.plugins.common.Check;
import org.sonar.plugins.common.InputFileContext;
import org.sonar.plugins.common.MultiFileProgressReport;
import org.sonar.plugins.common.measures.DurationStatistics;
import org.sonar.plugins.common.measures.MemoryMonitor;
import org.sonar.plugins.common.measures.TelemetryReporter;
import org.sonar.plugins.common.thread.ParallelizationManager;

public class Analyzer {
    public static final Version HIDDEN_FILES_SUPPORTED_API_VERSION = Version.create((int)12, (int)0);
    public static final String ANALYZED_FILES_MEASURE_KEY = "analyzed_files_count";
    public static final String ANALYZED_HIDDEN_FILES_MEASURE_KEY = "analyzed_hidden_files_count";
    private static final Logger LOG = LoggerFactory.getLogger(Analyzer.class);
    private final SensorContext sensorContext;
    private final ParallelizationManager parallelizationManager;
    protected final DurationStatistics durationStatistics;
    private final List<Check> suitableChecks;
    private final String analysisName;
    private final TelemetryReporter telemetryReporter;
    private final MemoryMonitor memoryMonitor;
    private final boolean supportedHiddenFileAnalysis;
    private final AtomicInteger analyzedFiles = new AtomicInteger(0);
    private final AtomicInteger analyzedHiddenFiles = new AtomicInteger(0);

    protected Analyzer(SensorContext sensorContext, ParallelizationManager parallelizationManager, DurationStatistics durationStatistics, List<Check> suitableChecks, String analysisName, TelemetryReporter telemetryReporter, MemoryMonitor memoryMonitor) {
        this.sensorContext = sensorContext;
        this.parallelizationManager = parallelizationManager;
        this.durationStatistics = durationStatistics;
        this.suitableChecks = suitableChecks;
        this.analysisName = analysisName;
        this.telemetryReporter = telemetryReporter;
        this.memoryMonitor = memoryMonitor;
        this.supportedHiddenFileAnalysis = sensorContext.runtime().getApiVersion().isGreaterThanOrEqual(HIDDEN_FILES_SUPPORTED_API_VERSION);
    }

    public void analyzeFiles(List<InputFile> inputFiles) {
        if (inputFiles.isEmpty()) {
            LOG.info("There are no files to be analyzed for the {}", (Object)this.analysisName);
            return;
        }
        LOG.info("Starting the {}", (Object)this.analysisName);
        this.analyzeAllFiles(inputFiles);
        this.memoryMonitor.addRecord("After the " + this.analysisName);
    }

    protected boolean shouldAnalyzeFile(InputFileContext inputFileContext) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyzeAllFiles(List<InputFile> inputFiles) {
        boolean cancelled = false;
        MultiFileProgressReport progressReport = new MultiFileProgressReport(this.analysisName);
        progressReport.start(inputFiles.size());
        try {
            for (InputFile inputFile : inputFiles) {
                if (this.sensorContext.isCancelled()) {
                    cancelled = true;
                    break;
                }
                this.parallelizationManager.submit(() -> {
                    progressReport.startAnalysisFor(inputFile.toString());
                    this.prepareAndAnalyze(inputFile);
                    progressReport.finishAnalysisFor(inputFile.toString());
                });
            }
            this.parallelizationManager.drainThreads();
        }
        finally {
            if (cancelled) {
                progressReport.cancel();
            } else {
                progressReport.stop();
            }
        }
        this.processFileTelemetryMeasures();
    }

    private void prepareAndAnalyze(InputFile inputFile) {
        Analyzer.triggerMetadataGeneration(inputFile);
        InputFileContext inputFileContext = this.durationStatistics.timed("preparingInputFiles::general", () -> this.buildInputFileContext(inputFile));
        if (inputFileContext != null && this.shouldAnalyzeFile(inputFileContext)) {
            this.durationStatistics.timed("analyzingAllChecks::general", () -> this.analyzeAllChecks(inputFileContext));
            this.countAnalyzedFile(inputFile);
        }
    }

    private static synchronized void triggerMetadataGeneration(InputFile inputFile) {
        inputFile.lines();
    }

    @CheckForNull
    private InputFileContext buildInputFileContext(InputFile inputFile) {
        try {
            return new InputFileContext(this.sensorContext, inputFile);
        }
        catch (IOException | RuntimeException e) {
            this.logAnalysisError(inputFile, e);
            return null;
        }
    }

    protected void analyzeAllChecks(InputFileContext inputFileContext) {
        try {
            for (Check check : this.suitableChecks) {
                check.analyze(inputFileContext);
            }
            inputFileContext.flushIssues();
        }
        catch (RuntimeException e) {
            this.logAnalysisError(inputFileContext.getInputFile(), e);
        }
    }

    protected void logAnalysisError(InputFile inputFile, Exception e) {
        String message = String.format("Unable to analyze file %s: %s", inputFile, e.getMessage());
        this.sensorContext.newAnalysisError().message(message).onFile(inputFile).save();
        LOG.warn(message);
    }

    private void countAnalyzedFile(InputFile inputFile) {
        this.analyzedFiles.incrementAndGet();
        if (this.supportedHiddenFileAnalysis && inputFile.isHidden()) {
            this.analyzedHiddenFiles.incrementAndGet();
        }
    }

    private void processFileTelemetryMeasures() {
        int numberOfAnalyzedFiles = this.analyzedFiles.get();
        LOG.debug("Analyzed files for the {}: {}", (Object)this.analysisName, (Object)numberOfAnalyzedFiles);
        this.telemetryReporter.addNumericMeasure(ANALYZED_FILES_MEASURE_KEY, numberOfAnalyzedFiles);
        if (this.supportedHiddenFileAnalysis) {
            this.telemetryReporter.addNumericMeasure(ANALYZED_HIDDEN_FILES_MEASURE_KEY, this.analyzedHiddenFiles.get());
        }
    }
}

