/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.common;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.SonarEdition;
import org.sonar.api.SonarProduct;
import org.sonar.api.SonarRuntime;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.IndexedFile;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.plugins.common.Check;
import org.sonar.plugins.common.NotBinaryFilePredicate;
import org.sonar.plugins.common.analyzer.Analyzer;
import org.sonar.plugins.common.analyzer.TextAndSecretsAnalyzer;
import org.sonar.plugins.common.git.CachingGitService;
import org.sonar.plugins.common.git.GitCliAndJGitService;
import org.sonar.plugins.common.git.GitService;
import org.sonar.plugins.common.git.GitTrackedFilePredicate;
import org.sonar.plugins.common.git.LazyGitService;
import org.sonar.plugins.common.measures.CiVendorFilesTelemetry;
import org.sonar.plugins.common.measures.DurationStatistics;
import org.sonar.plugins.common.measures.MemoryMonitor;
import org.sonar.plugins.common.measures.TelemetryReporter;
import org.sonar.plugins.common.thread.ParallelizationManager;
import org.sonar.plugins.common.warnings.AnalysisWarningsWrapper;
import org.sonar.plugins.common.warnings.DefaultAnalysisWarningsWrapper;
import org.sonar.plugins.secrets.SecretsCheckList;
import org.sonar.plugins.secrets.api.SecretsSpecificationLoader;
import org.sonar.plugins.secrets.api.SpecificationBasedCheck;
import org.sonar.plugins.secrets.api.SpecificationConfiguration;
import org.sonar.plugins.secrets.api.task.RegexMatchingManager;
import org.sonar.plugins.secrets.configuration.SecretsSpecificationContainer;
import org.sonar.plugins.secrets.utils.CheckContainer;
import org.sonar.plugins.text.TextCheckList;
import org.sonar.plugins.text.checks.BIDICharacterCheck;
import org.sonar.plugins.text.checks.TagBlockCheck;

public class TextAndSecretsSensor
implements Sensor {
    private static final Logger LOG = LoggerFactory.getLogger(TextAndSecretsSensor.class);
    public static final String EXCLUDED_FILE_SUFFIXES_KEY = "sonar.text.excluded.file.suffixes";
    public static final String TEXT_INCLUSIONS_KEY = "sonar.text.inclusions";
    public static final String TEXT_INCLUSIONS_DEFAULT_VALUE = "**/*.sh,**/*.bash,**/*.zsh,**/*.ksh,**/*.ps1,**/*.properties,**/*.conf,**/*.pem,**/*.config,.env,.aws/config,**/*.key";
    private static final String ANALYZE_ALL_FILES_KEY = "sonar.text.analyzeAllFiles";
    public static final String REGEX_MATCH_TIMEOUT_KEY = "sonar.text.regex.timeout.match";
    public static final String REGEX_EXECUTION_TIMEOUT_KEY = "sonar.text.regex.timeout.execution";
    public static final String ANALYZER_ACTIVATION_KEY = "sonar.text.activate";
    public static final boolean ANALYZER_ACTIVATION_DEFAULT_VALUE = true;
    public static final String INCLUSIONS_ACTIVATION_KEY = "sonar.text.inclusions.activate";
    public static final boolean INCLUSIONS_ACTIVATION_DEFAULT_VALUE = true;
    public static final String THREAD_NUMBER_KEY = "sonar.text.threads";
    public static final String TEXT_CATEGORY = "Secrets";
    public static final String SONAR_TESTS_KEY = "sonar.tests";
    public static final String ALL_TRACKED_TEXT_FILES_MEASURE_KEY = "all_tracked_text_files_count";
    public static final String SENSOR_DISABLED_MEASURE_KEY = "is_sensor_disabled";
    public static final FilePredicate LANGUAGE_FILE_PREDICATE = inputFile -> inputFile.language() != null;
    protected final CheckFactory checkFactory;
    protected final SonarRuntime sonarRuntime;
    protected final AnalysisWarningsWrapper analysisWarnings;
    private final SecretsSpecificationContainer secretsSpecificationContainer;
    private final CheckContainer checkContainer;
    protected DurationStatistics durationStatistics;
    protected TelemetryReporter telemetryReporter;
    protected MemoryMonitor memoryMonitor;
    protected ParallelizationManager parallelizationManager;
    protected GitService gitService;
    private GitTrackedFilePredicate gitTrackedFilePredicate;

    public TextAndSecretsSensor(SonarRuntime sonarRuntime, CheckFactory checkFactory, SecretsSpecificationContainer secretsSpecificationContainer, CheckContainer checkContainer) {
        this(sonarRuntime, checkFactory, DefaultAnalysisWarningsWrapper.NOOP_ANALYSIS_WARNINGS, secretsSpecificationContainer, checkContainer);
    }

    public TextAndSecretsSensor(SonarRuntime sonarRuntime, CheckFactory checkFactory, AnalysisWarningsWrapper analysisWarnings, SecretsSpecificationContainer secretsSpecificationContainer, CheckContainer checkContainer) {
        this.sonarRuntime = sonarRuntime;
        this.checkFactory = checkFactory;
        this.analysisWarnings = analysisWarnings;
        this.secretsSpecificationContainer = secretsSpecificationContainer;
        this.checkContainer = checkContainer;
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.name("TextAndSecretsSensor").createIssuesForRuleRepositories(new String[]{"text", "secrets"}).processesFilesIndependently().global();
        this.activateHiddenFilesProcessing(descriptor);
    }

    protected void activateHiddenFilesProcessing(SensorDescriptor descriptor) {
        if (TextAndSecretsSensor.isHiddenFilesAnalysisSupported(this.sonarRuntime)) {
            descriptor.processesHiddenFiles();
        }
    }

    public void execute(SensorContext sensorContext) {
        if (!TextAndSecretsSensor.isActive(sensorContext)) {
            LOG.info("The text and secrets analysis was deactivated using the property \"{}\"", (Object)ANALYZER_ACTIVATION_KEY);
            LOG.info("Experiencing any issues with the text and secrets analysis? Please report them at https://community.sonarsource.com/tag/secrets - your feedback helps us improve the product!");
            new TelemetryReporter(sensorContext).addNumericMeasure(SENSOR_DISABLED_MEASURE_KEY, 1).report();
            return;
        }
        this.initialize(sensorContext);
        List<Check> activeChecks = this.getActiveChecks();
        if (activeChecks.isEmpty()) {
            return;
        }
        this.initializeChecks(activeChecks, this.createSpecificationConfiguration(sensorContext));
        this.runAnalysis(sensorContext, activeChecks);
        this.processMetrics();
        this.cleanUp();
    }

    protected SpecificationConfiguration createSpecificationConfiguration(SensorContext sensorContext) {
        String value = sensorContext.config().get(SONAR_TESTS_KEY).orElse("");
        if (value.isBlank() && !TextAndSecretsSensor.isSonarLintContext(sensorContext.runtime())) {
            String message = "The property \"%s\" is not set. To improve the analysis accuracy, we categorize a file as a test file if any of the following is true:\n  * The filename starts with \"test\"\n  * The filename contains \"test.\" or \"tests.\"\n  * Any directory in the file path is named: \"doc\", \"docs\", \"test\", \"tests\", \"mock\" or \"mocks\"\n  * Any directory in the file path has a name ending in \"test\" or \"tests\"\n".formatted(SONAR_TESTS_KEY);
            LOG.info(message);
            return new SpecificationConfiguration(true);
        }
        return new SpecificationConfiguration(false);
    }

    protected void runAnalysis(SensorContext sensorContext, List<Check> activeChecks) {
        this.runTextAndSecretsAnalysis(sensorContext, activeChecks);
    }

    private void runTextAndSecretsAnalysis(SensorContext sensorContext, List<Check> activeChecks) {
        List<Check> suitableChecks = TextAndSecretsAnalyzer.filterSuitableChecks(activeChecks);
        if (suitableChecks.isEmpty()) {
            return;
        }
        boolean shouldAnalyzeAllFiles = TextAndSecretsSensor.shouldAnalyzeAllFiles(sensorContext);
        NotBinaryFilePredicate notBinaryFilePredicate = TextAndSecretsSensor.notBinaryFilePredicate(sensorContext);
        FilePredicate filePredicate = this.constructGeneralFilePredicate(sensorContext, notBinaryFilePredicate, shouldAnalyzeAllFiles);
        List inputFiles = this.durationStatistics.timed("applyFilePredicate::general", () -> TextAndSecretsSensor.getInputFiles(sensorContext, filePredicate));
        TextAndSecretsAnalyzer analyzer = new TextAndSecretsAnalyzer(sensorContext, this.parallelizationManager, this.durationStatistics, suitableChecks, this.telemetryReporter, this.memoryMonitor, this.checkContainer);
        this.durationStatistics.timed("analyzerTotal::general", () -> analyzer.analyzeFiles(inputFiles));
        this.logCheckBasedStatistics(suitableChecks);
        this.reportAllTrackedTextFilesMeasure(sensorContext, notBinaryFilePredicate);
    }

    private FilePredicate constructGeneralFilePredicate(SensorContext sensorContext, FilePredicate notBinaryFilePredicate, boolean analyzeAllFiles) {
        LOG.info("Start fetching files for the text and secrets analysis");
        if (analyzeAllFiles) {
            LOG.info("Retrieving all except binary files");
            return notBinaryFilePredicate;
        }
        FilePredicate nonHiddenLanguageFilesPredicate = TextAndSecretsSensor.filterHiddenFiles(sensorContext, LANGUAGE_FILE_PREDICATE);
        if (!TextAndSecretsSensor.isGitAndInclusionsActive(sensorContext)) {
            LOG.info("Retrieving only language associated files, \"{}\" property is deactivated", (Object)INCLUSIONS_ACTIVATION_KEY);
            return nonHiddenLanguageFilesPredicate;
        }
        this.initializeGitPredicate(sensorContext);
        if (!this.gitTrackedFilePredicate.isGitStatusSuccessful()) {
            LOG.warn("Retrieving only language associated files, make sure to run the analysis inside a git repository to make use of inclusions specified via \"{}\"", (Object)TEXT_INCLUSIONS_KEY);
            return nonHiddenLanguageFilesPredicate;
        }
        FilePredicate includedFilesPredicate = TextAndSecretsSensor.includedPathPatternsFilePredicate(sensorContext);
        FilePredicates predicates = sensorContext.fileSystem().predicates();
        if (TextAndSecretsSensor.isHiddenFilesAnalysisSupported(sensorContext.runtime())) {
            includedFilesPredicate = predicates.or(IndexedFile::isHidden, includedFilesPredicate);
        }
        LOG.info("Retrieving language associated files and files included via \"{}\" that are tracked by git", (Object)TEXT_INCLUSIONS_KEY);
        return predicates.or(nonHiddenLanguageFilesPredicate, predicates.and(includedFilesPredicate, (FilePredicate)this.gitTrackedFilePredicate));
    }

    private void reportAllTrackedTextFilesMeasure(SensorContext sensorContext, NotBinaryFilePredicate notBinaryFilePredicate) {
        if (TextAndSecretsSensor.isSonarLintContext(sensorContext.runtime())) {
            return;
        }
        int allTrackedTextFilesCount = this.durationStatistics.timed("countAllTrackedTextFiles::general", () -> this.countAllTrackedTextFiles(sensorContext, notBinaryFilePredicate));
        this.telemetryReporter.addNumericMeasure(ALL_TRACKED_TEXT_FILES_MEASURE_KEY, allTrackedTextFilesCount);
    }

    private int countAllTrackedTextFiles(SensorContext sensorContext, NotBinaryFilePredicate notBinaryFilePredicate) {
        if (this.gitTrackedFilePredicate == null) {
            return 0;
        }
        Path baseDir = sensorContext.fileSystem().baseDir().toPath();
        GitTrackedFilePredicate trackedFilesPredicate = new GitTrackedFilePredicate(baseDir, this.gitService, LANGUAGE_FILE_PREDICATE);
        if (!trackedFilesPredicate.isGitStatusSuccessful()) {
            return 0;
        }
        FilePredicates predicates = sensorContext.fileSystem().predicates();
        FilePredicate allTrackedTextFilesPredicate = predicates.and((FilePredicate)trackedFilesPredicate, (FilePredicate)notBinaryFilePredicate);
        allTrackedTextFilesPredicate = predicates.or(LANGUAGE_FILE_PREDICATE, allTrackedTextFilesPredicate);
        return (int)StreamSupport.stream(sensorContext.fileSystem().inputFiles(allTrackedTextFilesPredicate).spliterator(), false).count();
    }

    private static NotBinaryFilePredicate notBinaryFilePredicate(SensorContext sensorContext) {
        return new NotBinaryFilePredicate(sensorContext.config().getStringArray(EXCLUDED_FILE_SUFFIXES_KEY));
    }

    private static FilePredicate includedPathPatternsFilePredicate(SensorContext sensorContext) {
        String[] includedPathPatterns = sensorContext.config().getStringArray(TEXT_INCLUSIONS_KEY);
        if (includedPathPatterns.length == 0) {
            return sensorContext.fileSystem().predicates().none();
        }
        ArrayList<FilePredicate> pathPatternsPredicates = new ArrayList<FilePredicate>();
        for (String pathPattern : includedPathPatterns) {
            FilePredicate filePredicate = sensorContext.fileSystem().predicates().matchesPathPattern(pathPattern);
            pathPatternsPredicates.add(filePredicate);
        }
        return sensorContext.fileSystem().predicates().or(pathPatternsPredicates);
    }

    private static FilePredicate filterHiddenFiles(SensorContext sensorContext, FilePredicate filePredicate) {
        if (TextAndSecretsSensor.isHiddenFilesAnalysisSupported(sensorContext.runtime())) {
            FilePredicates predicates = sensorContext.fileSystem().predicates();
            FilePredicate onlyNonHiddenFiles = inputFile -> !inputFile.isHidden();
            return predicates.and(onlyNonHiddenFiles, filePredicate);
        }
        return filePredicate;
    }

    private static boolean isHiddenFilesAnalysisSupported(SonarRuntime sonarRuntime) {
        return !TextAndSecretsSensor.isSonarLintContext(sonarRuntime) && sonarRuntime.getApiVersion().isGreaterThanOrEqual(Analyzer.HIDDEN_FILES_SUPPORTED_API_VERSION);
    }

    protected static List<InputFile> getInputFiles(SensorContext sensorContext, FilePredicate filePredicate) {
        ArrayList<InputFile> inputFiles = new ArrayList<InputFile>();
        FileSystem fileSystem = sensorContext.fileSystem();
        for (InputFile inputFile : fileSystem.inputFiles(filePredicate)) {
            inputFiles.add(inputFile);
        }
        return inputFiles;
    }

    protected List<Check> getActiveChecks() {
        ArrayList<Check> checks = new ArrayList<Check>(this.checkFactory.create("text").addAnnotatedChecks(new TextCheckList().checks()).all());
        checks.addAll(this.checkFactory.create("secrets").addAnnotatedChecks(new SecretsCheckList().checks()).all());
        return checks;
    }

    private void initialize(SensorContext sensorContext) {
        this.memoryMonitor = new MemoryMonitor(sensorContext.config());
        this.durationStatistics = new DurationStatistics(sensorContext.config());
        this.telemetryReporter = new TelemetryReporter(sensorContext);
        this.telemetryReporter.startRecordingSensorTime();
        CiVendorFilesTelemetry.measureProjectsCIFilesInclusion(sensorContext, this.telemetryReporter);
        this.initializeParallelizationManager(sensorContext);
        this.initializeGitService(sensorContext);
        TextAndSecretsSensor.initializeOptionalConfigValue(sensorContext, REGEX_MATCH_TIMEOUT_KEY, RegexMatchingManager::setTimeoutMs);
        TextAndSecretsSensor.initializeOptionalConfigValue(sensorContext, REGEX_EXECUTION_TIMEOUT_KEY, RegexMatchingManager::setUninterruptibleTimeoutMs);
        this.secretsSpecificationContainer.initialize(this::constructSpecificationLoader, this.durationStatistics);
    }

    private void initializeParallelizationManager(SensorContext sensorContext) {
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        Optional threadOption = sensorContext.config().getInt(THREAD_NUMBER_KEY);
        int threads = availableProcessors;
        String logMessageSuffix = "";
        if (threadOption.isPresent()) {
            threads = (Integer)threadOption.get();
            logMessageSuffix = ", according to the value of \"sonar.text.threads\" property";
            if (threads > availableProcessors) {
                if (TextAndSecretsSensor.isSonarCloudContext(sensorContext)) {
                    threads = availableProcessors;
                    logMessageSuffix = ", \"sonar.text.threads\" is ignored";
                } else {
                    this.logWarningConsoleUI("\"sonar.text.threads\" property was set to " + threads + ", which is greater than the number of available processors: " + availableProcessors + ".\nIt is recommended to let the analyzer detect the number of threads automatically by not setting the property.\nFor more information, visit the documentation page.");
                }
            }
        }
        LOG.info("Available processors: {}", (Object)availableProcessors);
        LOG.info("Using {} {} for analysis{}.", threads, threads != 1 ? "threads" : "thread", logMessageSuffix);
        this.parallelizationManager = new ParallelizationManager(threads);
        RegexMatchingManager.initialize(threads);
    }

    private void initializeGitService(SensorContext sensorContext) {
        Path baseDir = sensorContext.fileSystem().baseDir().toPath();
        this.gitService = this.createGitService(baseDir);
    }

    protected void initializeChecks(List<Check> checks, SpecificationConfiguration specificationConfiguration) {
        this.durationStatistics.timed("initializingSecretMatchers::general", () -> {
            for (Check activeCheck : checks) {
                if (activeCheck instanceof SpecificationBasedCheck) {
                    SpecificationBasedCheck specificationBasedCheck = (SpecificationBasedCheck)activeCheck;
                    specificationBasedCheck.initialize(this.secretsSpecificationContainer.getSpecificationLoader(), this.durationStatistics, specificationConfiguration);
                    continue;
                }
                if (activeCheck instanceof BIDICharacterCheck) {
                    BIDICharacterCheck bidiCharacterCheck = (BIDICharacterCheck)activeCheck;
                    bidiCharacterCheck.initialize(this.durationStatistics);
                    continue;
                }
                if (!(activeCheck instanceof TagBlockCheck)) continue;
                TagBlockCheck tagBlockCheck = (TagBlockCheck)activeCheck;
                tagBlockCheck.initialize(this.durationStatistics);
            }
        });
        this.checkContainer.initialize(checks, this.secretsSpecificationContainer.getSpecificationLoader(), this.durationStatistics);
    }

    private static void initializeOptionalConfigValue(SensorContext sensorContext, String key, Consumer<Integer> setConfigValue) {
        try {
            Optional valueAsInt = sensorContext.config().getInt(key);
            valueAsInt.ifPresent(setConfigValue);
        }
        catch (IllegalStateException e) {
            LOG.debug("Provided value with key \"{}\" is not parseable as an integer", (Object)key, (Object)e);
        }
    }

    private void initializeGitPredicate(SensorContext sensorContext) {
        if (this.gitTrackedFilePredicate == null) {
            Path baseDir = sensorContext.fileSystem().baseDir().toPath();
            this.gitTrackedFilePredicate = this.durationStatistics.timed("trackedByGitPredicate::general", () -> new GitTrackedFilePredicate(baseDir, this.gitService, TextAndSecretsSensor.filterHiddenFiles(sensorContext, LANGUAGE_FILE_PREDICATE)));
        }
    }

    private void logWarningConsoleUI(String message) {
        LOG.warn(message);
        this.analysisWarnings.addWarning(message);
    }

    protected SecretsSpecificationLoader constructSpecificationLoader() {
        return new SecretsSpecificationLoader();
    }

    public GitService createGitService(Path baseDir) {
        return new LazyGitService(() -> new CachingGitService(new GitCliAndJGitService(baseDir)));
    }

    protected void logCheckBasedStatistics(List<Check> activeChecks) {
    }

    private void processMetrics() {
        this.telemetryReporter.endRecordingSensorTime(this.getEditionName());
        this.telemetryReporter.report();
        this.durationStatistics.log();
        if (this.gitTrackedFilePredicate != null) {
            this.gitTrackedFilePredicate.logSummary();
        }
        this.memoryMonitor.addRecord("End of the sensor");
        this.memoryMonitor.logMemory();
    }

    protected String getEditionName() {
        return SonarEdition.COMMUNITY.getLabel();
    }

    private void cleanUp() {
        this.durationStatistics = null;
        this.telemetryReporter = null;
        this.memoryMonitor = null;
        this.gitTrackedFilePredicate = null;
        this.parallelizationManager.shutdown();
        RegexMatchingManager.shutdown();
        try {
            this.gitService.close();
        }
        catch (Exception e) {
            LOG.debug("Error closing GitService", e);
        }
    }

    private static boolean isActive(SensorContext sensorContext) {
        return sensorContext.config().getBoolean(ANALYZER_ACTIVATION_KEY).orElse(true);
    }

    private static boolean isGitAndInclusionsActive(SensorContext sensorContext) {
        return sensorContext.config().getBoolean(INCLUSIONS_ACTIVATION_KEY).orElse(true);
    }

    public static boolean isSonarLintContext(SonarRuntime runtime) {
        return runtime.getProduct() == SonarProduct.SONARLINT;
    }

    private static boolean isSonarCloudContext(SensorContext sensorContext) {
        return !TextAndSecretsSensor.isSonarLintContext(sensorContext.runtime()) && sensorContext.runtime().getEdition() == SonarEdition.SONARCLOUD;
    }

    private static boolean shouldAnalyzeAllFiles(SensorContext sensorContext) {
        return TextAndSecretsSensor.isSonarLintContext(sensorContext.runtime()) || sensorContext.config().getBoolean(ANALYZE_ALL_FILES_KEY).orElse(false) != false;
    }
}

