/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.common;

import java.util.List;
import org.sonar.api.Plugin;
import org.sonar.api.PropertyType;
import org.sonar.api.config.PropertyDefinition;
import org.sonar.plugins.common.TextAndSecretsSensor;
import org.sonar.plugins.common.warnings.DefaultAnalysisWarningsWrapper;
import org.sonar.plugins.secrets.SecretsLanguage;
import org.sonar.plugins.secrets.SecretsRulesDefinition;
import org.sonar.plugins.secrets.configuration.SecretsSpecificationContainer;
import org.sonar.plugins.secrets.utils.CheckContainer;
import org.sonar.plugins.text.TextLanguage;
import org.sonar.plugins.text.TextRuleDefinition;

public class TextAndSecretsPlugin
implements Plugin {
    private static final String GENERAL_SUBCATEGORY = "General";

    public void define(Plugin.Context context) {
        context.addExtensions(TextAndSecretsSensor.class, DefaultAnalysisWarningsWrapper.class, new Object[]{TextLanguage.class, TextRuleDefinition.class, TextRuleDefinition.DefaultQualityProfile.class, SecretsLanguage.class, SecretsRulesDefinition.class, SecretsRulesDefinition.DefaultQualityProfile.class, SecretsSpecificationContainer.class, CheckContainer.class});
        context.addExtensions(TextAndSecretsPlugin.createUIProperties());
    }

    public static List<PropertyDefinition> createUIProperties() {
        return List.of(PropertyDefinition.builder((String)"sonar.text.activate").index(1).defaultValue(String.valueOf(true)).name("Activate Secrets Analysis").description("Disabling Secrets analysis ensures that no files are analyzed for containing secrets.").type(PropertyType.BOOLEAN).onConfigScopes(PropertyDefinition.ConfigScope.PROJECT, new PropertyDefinition.ConfigScope[0]).category("Secrets").subCategory(GENERAL_SUBCATEGORY).build(), PropertyDefinition.builder((String)"sonar.text.inclusions.activate").index(2).defaultValue(String.valueOf(true)).name("Activate inclusion of custom file path patterns").description("Disabling custom file path patterns ensures that only files associated to a language will get analyzed.").type(PropertyType.BOOLEAN).onConfigScopes(PropertyDefinition.ConfigScope.PROJECT, new PropertyDefinition.ConfigScope[0]).category("Secrets").subCategory(GENERAL_SUBCATEGORY).build(), PropertyDefinition.builder((String)"sonar.text.excluded.file.suffixes").defaultValue("").category("Secrets").name("Additional binary file suffixes").multiValues(true).description("Additional list of binary file suffixes that should not be analyzed with rules targeting text files.").subCategory(GENERAL_SUBCATEGORY).onConfigScopes(PropertyDefinition.ConfigScope.PROJECT, new PropertyDefinition.ConfigScope[0]).build(), PropertyDefinition.builder((String)"sonar.text.inclusions").defaultValue("**/*.sh,**/*.bash,**/*.zsh,**/*.ksh,**/*.ps1,**/*.properties,**/*.conf,**/*.pem,**/*.config,.env,.aws/config,**/*.key").category("Secrets").name("List of file path patterns to include").multiValues(true).description("List of file path patterns that should be analyzed with rules targeting text files (ie. Secret rules, BIDI rule), in addition to those associated to a language. This is only applied when the scanner detects a git repository. It's not possible to analyze files or directories starting with a dot on UNIX systems.").subCategory(GENERAL_SUBCATEGORY).onConfigScopes(PropertyDefinition.ConfigScope.PROJECT, new PropertyDefinition.ConfigScope[0]).build());
    }
}

