/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.common;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.plugins.common.thread.ThreadUtils;

public class MultiFileProgressReport
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(MultiFileProgressReport.class);
    private static final int MAX_NUMBER_OF_FILES_TO_DISPLAY = 3;
    private static final int DEFAULT_PROGRESS_UPDATE_PERIOD_MILLIS = 10000;
    private final Collection<String> currentFileNames = new ConcurrentLinkedDeque<String>();
    private final Thread thread;
    private final long progressUpdatePeriod;
    private final String analysisName;
    private long size;
    private long numberOfFinishedFiles;
    private boolean success;
    private final AtomicBoolean interrupted = new AtomicBoolean();

    public MultiFileProgressReport(String analysisName) {
        this(10000L, analysisName);
    }

    public MultiFileProgressReport(long progressUpdatePeriod, String analysisName) {
        this.progressUpdatePeriod = progressUpdatePeriod;
        this.analysisName = analysisName;
        this.interrupted.set(false);
        this.thread = new Thread(this);
        ThreadUtils.setThreadName(this.thread, "Progress of the %s".formatted(analysisName));
        this.thread.setDaemon(true);
        this.thread.setUncaughtExceptionHandler((thread, throwable) -> LOG.debug("Uncaught exception in the progress report thread: {}", (Object)throwable.getClass().getCanonicalName()));
    }

    @Override
    public void run() {
        LOG.info("{} source {} to be analyzed for the {}", this.size, MultiFileProgressReport.pluralizeFile(this.size), this.analysisName);
        while (!this.interrupted.get() && !Thread.currentThread().isInterrupted()) {
            try {
                Thread.sleep(this.progressUpdatePeriod);
                this.logCurrentProgress();
            }
            catch (InterruptedException e) {
                this.interrupted.set(true);
                this.thread.interrupt();
                break;
            }
        }
        if (this.success) {
            LOG.info("{}/{} source {} {} been analyzed for the {}", this.size, this.size, MultiFileProgressReport.pluralizeFile(this.size), MultiFileProgressReport.pluralizeHas(this.size), this.analysisName);
        }
    }

    private static String pluralizeFile(long count) {
        if (count == 1L) {
            return "file";
        }
        return "files";
    }

    private static String pluralizeHas(long count) {
        if (count == 1L) {
            return "has";
        }
        return "have";
    }

    public synchronized void start(int size) {
        this.size = size;
        this.thread.start();
    }

    public void startAnalysisFor(String fileName) {
        this.currentFileNames.add(fileName);
    }

    public synchronized void finishAnalysisFor(String fileName) {
        if (!this.currentFileNames.remove(fileName)) {
            LOG.debug("Couldn't finish progress report of file \"{}\", as it was not in the list of files being analyzed", (Object)fileName);
            return;
        }
        if (this.numberOfFinishedFiles < this.size) {
            ++this.numberOfFinishedFiles;
        } else {
            LOG.debug("Reported finished analysis on more files than expected");
        }
    }

    public synchronized void stop() {
        this.interrupted.set(true);
        this.success = true;
        this.thread.interrupt();
        this.join();
    }

    public synchronized void cancel() {
        this.interrupted.set(true);
        this.thread.interrupt();
        this.join();
    }

    private void join() {
        try {
            this.thread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logCurrentProgress() {
        LinkedHashSet<String> currentFileNamesCopy;
        StringBuilder sb = new StringBuilder();
        MultiFileProgressReport multiFileProgressReport = this;
        synchronized (multiFileProgressReport) {
            currentFileNamesCopy = new LinkedHashSet<String>(this.currentFileNames);
        }
        int numberOfFiles = currentFileNamesCopy.size();
        sb.append(this.numberOfFinishedFiles).append("/").append(this.size).append(" files analyzed, current ").append(MultiFileProgressReport.pluralizeFile(numberOfFiles)).append(": ");
        boolean debugEnabled = LOG.isDebugEnabled();
        if (numberOfFiles == 0) {
            sb.append("none");
        } else {
            int numberOfFilesToDisplay = debugEnabled ? numberOfFiles : Math.min(numberOfFiles, 3);
            String fileNamesToDisplay = currentFileNamesCopy.stream().limit(numberOfFilesToDisplay).collect(Collectors.joining(", "));
            sb.append(fileNamesToDisplay);
            if (numberOfFiles > numberOfFilesToDisplay) {
                sb.append(", ...");
            }
        }
        MultiFileProgressReport.logSynchronized(sb.toString(), debugEnabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void logSynchronized(String message, boolean debug) {
        Logger logger = LOG;
        synchronized (logger) {
            if (debug) {
                LOG.debug(message);
            } else {
                LOG.info(message);
            }
            LOG.notifyAll();
        }
    }
}

