/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextPointer;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.rule.RuleKey;
import org.sonar.plugins.common.BinaryFileUtils;
import org.sonar.plugins.secrets.configuration.model.Selectivity;

public class InputFileContext {
    private static final Logger LOG = LoggerFactory.getLogger(InputFileContext.class);
    private static final char LINE_FEED = '\n';
    private final SensorContext sensorContext;
    private final InputFile inputFile;
    private final boolean hasNonTextCharacters;
    private final List<String> lines;
    private final NavigableSet<Integer> lineStartOffsets = new TreeSet<Integer>();
    private final Map<Integer, Integer> offsetToLine = new HashMap<Integer, Integer>();
    private final String normalizedContent;
    private final List<CandidateIssue> candidateIssues = new ArrayList<CandidateIssue>();

    public InputFileContext(SensorContext sensorContext, InputFile inputFile) throws IOException {
        this.sensorContext = sensorContext;
        this.inputFile = inputFile;
        ArrayList<String> contentLines = new ArrayList<String>();
        boolean checkNonTextCharacters = inputFile.language() == null;
        try (InputStream in = inputFile.inputStream();){
            BufferedReader reader = new BufferedReader(new InputStreamReader(in, inputFile.charset()));
            String line = reader.readLine();
            while (line != null) {
                if (checkNonTextCharacters && BinaryFileUtils.hasNonTextCharacters(line)) {
                    this.hasNonTextCharacters = true;
                    this.lines = Collections.emptyList();
                    this.normalizedContent = "";
                    return;
                }
                contentLines.add(line);
                line = reader.readLine();
            }
        }
        this.hasNonTextCharacters = false;
        this.lines = contentLines;
        this.normalizedContent = this.buildNormalizedContentAndCalculateOffsets();
    }

    private String buildNormalizedContentAndCalculateOffsets() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.lines.size(); ++i) {
            int lineStartOffset = stringBuilder.length();
            int lineNumber = i + 1;
            this.lineStartOffsets.add(lineStartOffset);
            this.offsetToLine.put(lineStartOffset, lineNumber);
            stringBuilder.append(this.lines.get(i));
            if (i >= this.lines.size() - 1) continue;
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    public void reportTextIssue(RuleKey ruleKey, int line, String message) {
        TextRange textRange = this.inputFile.selectLine(line);
        InputFileContext.createAndSaveIssue(this.sensorContext, ruleKey, this.inputFile, textRange, message);
    }

    public void reportIssueOnTextRange(RuleKey ruleKey, Selectivity ruleSelectivity, TextRange textRange, String message) {
        this.candidateIssues.add(new CandidateIssue(ruleKey, ruleSelectivity, textRange, message));
    }

    public void reportIssueOnFile(RuleKey ruleKey, String message) {
        InputFileContext.createAndSaveIssue(this.sensorContext, ruleKey, this.inputFile, null, message);
    }

    public void flushIssues() {
        List<List<CandidateIssue>> sortedIssueGroups = this.groupAndPrioritizeOverlappingIssues();
        if (LOG.isDebugEnabled()) {
            this.logOverlappingIssues(sortedIssueGroups);
        }
        sortedIssueGroups.stream().filter(group -> !group.isEmpty()).map(group -> (CandidateIssue)group.get(0)).forEach(issue -> InputFileContext.createAndSaveIssue(this.sensorContext, issue.ruleKey, this.inputFile, issue.textRange, issue.message));
        this.candidateIssues.clear();
    }

    private static synchronized void createAndSaveIssue(SensorContext sensorContext, RuleKey ruleKey, InputFile inputFile, @Nullable TextRange textRange, String message) {
        NewIssue issue = sensorContext.newIssue();
        NewIssueLocation issueLocation = issue.newLocation().on((InputComponent)inputFile).message(message);
        if (textRange != null) {
            issueLocation.at(textRange);
        }
        issue.forRule(ruleKey).at(issueLocation).save();
    }

    public TextRange newTextRangeFromFileOffsets(int startOffset, int endOffset) {
        int lineStartOfStartOffset = this.lineStartOffSet(startOffset);
        int lineStartOfEndOffset = this.lineStartOffSet(endOffset);
        Integer startOffSetLineNumber = this.offsetToLine.get(lineStartOfStartOffset);
        Integer endOffSetLineNumber = this.offsetToLine.get(lineStartOfEndOffset);
        try {
            TextPointer startPointer = this.inputFile.newPointer(startOffSetLineNumber.intValue(), startOffset - lineStartOfStartOffset);
            TextPointer endPointer = this.inputFile.newPointer(endOffSetLineNumber.intValue(), endOffset - lineStartOfEndOffset);
            return this.inputFile.newRange(startPointer, endPointer);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Invalid offsets: startOffset=" + startOffset + ", endOffset=" + endOffset, e);
        }
    }

    public int lineStartOffSet(int offset) {
        Integer floor = this.lineStartOffsets.floor(offset);
        if (floor == null) {
            throw new IllegalStateException("Invalid offset: offset=" + offset);
        }
        return floor;
    }

    public int offsetToLineNumber(int offset) {
        Integer floor = this.lineStartOffSet(offset);
        return this.offsetToLine.get(floor);
    }

    public boolean hasNonTextCharacters() {
        return this.hasNonTextCharacters;
    }

    public String content() {
        return this.normalizedContent;
    }

    public List<String> lines() {
        return this.lines;
    }

    public String toString() {
        return this.inputFile.toString();
    }

    public InputFile getInputFile() {
        return this.inputFile;
    }

    public FileSystem getFileSystem() {
        return this.sensorContext.fileSystem();
    }

    private List<List<CandidateIssue>> groupAndPrioritizeOverlappingIssues() {
        ArrayList<List<CandidateIssue>> groups = new ArrayList<List<CandidateIssue>>();
        for (CandidateIssue candidateIssue : this.candidateIssues) {
            groups.stream().filter(group -> group.stream().anyMatch(it -> it.textRange.overlap(candidateIssue.textRange))).findFirst().ifPresentOrElse(group -> group.add(candidateIssue), () -> {
                ArrayList<CandidateIssue> newGroup = new ArrayList<CandidateIssue>();
                newGroup.add(candidateIssue);
                groups.add(newGroup);
            });
        }
        for (List list : groups) {
            list.sort(Comparator.comparing(it -> it.selectivity.priority()));
        }
        return groups;
    }

    private void logOverlappingIssues(List<List<CandidateIssue>> issueGroups) {
        issueGroups.stream().filter(group -> group.size() > 1).forEach(group -> LOG.debug("Overlapping issues detected for file {}: Issue {} prioritized over {}", this.inputFile, ((CandidateIssue)group.get(0)).keyAndRange(), group.stream().skip(1L).map(CandidateIssue::keyAndRange).collect(Collectors.joining(", "))));
    }

    private record CandidateIssue(RuleKey ruleKey, Selectivity selectivity, TextRange textRange, String message) {
        public String keyAndRange() {
            return "[" + String.valueOf(this.ruleKey) + ", " + String.valueOf(this.textRange) + "]";
        }
    }
}

