/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.common;

import java.util.List;
import org.sonar.api.SonarRuntime;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonar.plugins.common.DefaultQualityProfileDefinition;
import org.sonarsource.analyzer.commons.RuleMetadataLoader;

public abstract class CommonRulesDefinition
implements RulesDefinition {
    private static final String RESOURCE_FOLDER_FORMAT = "/%s/sonar/l10n/%s/rules/%s";
    protected static final String DEFAULT_PACKAGE_PREFIX = "org";
    private final SonarRuntime sonarRuntime;
    public final String repositoryKey;
    public final String repositoryName;
    public final String languageKey;

    protected CommonRulesDefinition(SonarRuntime sonarRuntime, String repositoryKey, String repositoryName, String languageKey) {
        this.sonarRuntime = sonarRuntime;
        this.repositoryKey = repositoryKey;
        this.repositoryName = repositoryName;
        this.languageKey = languageKey;
    }

    public void define(RulesDefinition.Context context) {
        RulesDefinition.NewRepository repository = context.createRepository(this.repositoryKey, this.languageKey).setName(this.repositoryName);
        this.loadRepository(this.packagePrefix(), repository, this.checks());
        repository.done();
    }

    public abstract List<Class<?>> checks();

    protected void loadRepository(String packagePrefix, RulesDefinition.NewRepository repository, List<Class<?>> checkClasses) {
        String resourcePath = CommonRulesDefinition.resourcePath(packagePrefix, this.repositoryKey, this.languageKey);
        String defaultProfilePath = DefaultQualityProfileDefinition.profilePath(packagePrefix, this.repositoryKey, this.languageKey);
        RuleMetadataLoader ruleMetadataLoader = new RuleMetadataLoader(resourcePath, defaultProfilePath, this.sonarRuntime);
        ruleMetadataLoader.addRulesByAnnotatedClass(repository, checkClasses);
    }

    public static String resourcePath(String packagePrefix, String repository, String language) {
        return String.format(RESOURCE_FOLDER_FORMAT, packagePrefix, repository, language);
    }

    public String packagePrefix() {
        return DEFAULT_PACKAGE_PREFIX;
    }
}

