/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.utils;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.networknt.schema.path.NodePath;
import com.networknt.schema.serialization.node.JsonNodeFactoryFactory;
import com.networknt.schema.serialization.node.TokenStreamLocationAware;
import java.io.IOException;
import java.io.InputStream;

public class JsonNodes {
    public static <T extends JsonNode> T get(JsonNode node, NodePath path) {
        int nameCount = path.getNameCount();
        JsonNode current = node;
        for (int x = 0; x < nameCount; ++x) {
            Object segment = path.getElement(x);
            T result = JsonNodes.get(current, segment);
            if (result == null) {
                return null;
            }
            current = result;
        }
        return (T)current;
    }

    public static <T extends JsonNode> T get(JsonNode node, Object propertyOrIndex) {
        JsonNode value = null;
        value = propertyOrIndex instanceof Number && node.isArray() ? node.get(((Number)propertyOrIndex).intValue()) : node.get(propertyOrIndex.toString());
        return (T)value;
    }

    public static JsonNode readTree(ObjectMapper objectMapper, String content, JsonNodeFactoryFactory jsonNodeFactoryFactory) {
        JsonNode jsonNode;
        block8: {
            JsonFactory factory = objectMapper.getFactory();
            JsonParser parser = factory.createParser(content);
            try {
                JsonNodeFactory nodeFactory = jsonNodeFactoryFactory.getJsonNodeFactory(parser);
                ObjectReader reader = objectMapper.reader(nodeFactory);
                JsonNode result = (JsonNode)reader.readTree(parser);
                JsonNode jsonNode2 = jsonNode = result != null ? result : nodeFactory.missingNode();
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Invalid input", e);
                }
            }
            parser.close();
        }
        return jsonNode;
    }

    public static JsonNode readTree(ObjectMapper objectMapper, InputStream inputStream, JsonNodeFactoryFactory jsonNodeFactoryFactory) {
        JsonNode jsonNode;
        block8: {
            JsonFactory factory = objectMapper.getFactory();
            JsonParser parser = factory.createParser(inputStream);
            try {
                JsonNodeFactory nodeFactory = jsonNodeFactoryFactory.getJsonNodeFactory(parser);
                ObjectReader reader = objectMapper.reader(nodeFactory);
                JsonNode result = (JsonNode)reader.readTree(parser);
                JsonNode jsonNode2 = jsonNode = result != null ? result : nodeFactory.missingNode();
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Invalid input", e);
                }
            }
            parser.close();
        }
        return jsonNode;
    }

    public static JsonLocation tokenStreamLocationOf(JsonNode jsonNode) {
        if (jsonNode instanceof TokenStreamLocationAware) {
            return ((TokenStreamLocationAware)((Object)jsonNode)).tokenStreamLocation();
        }
        throw new IllegalArgumentException("JsonNode does not contain the location information.");
    }
}

