/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.Schema;
import com.networknt.schema.SchemaContext;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.SchemaRef;
import com.networknt.schema.annotation.Annotation;
import com.networknt.schema.keyword.BaseKeywordValidator;
import com.networknt.schema.keyword.KeywordType;
import com.networknt.schema.path.NodePath;
import com.networknt.schema.utils.SchemaRefs;
import com.networknt.schema.walk.WalkHandler;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;

public class PropertiesValidator
extends BaseKeywordValidator {
    public static final String PROPERTY = "properties";
    private final Map<String, Schema> schemas = new LinkedHashMap<String, Schema>();

    public PropertiesValidator(SchemaLocation schemaLocation, JsonNode schemaNode, Schema parentSchema, SchemaContext schemaContext) {
        super(KeywordType.PROPERTIES, schemaNode, schemaLocation, parentSchema, schemaContext);
        Iterator<Map.Entry<String, JsonNode>> it = schemaNode.fields();
        while (it.hasNext()) {
            Map.Entry<String, JsonNode> entry = it.next();
            String pname = entry.getKey();
            this.schemas.put(pname, schemaContext.newSchema(schemaLocation.append(pname), entry.getValue(), parentSchema));
        }
    }

    @Override
    public void validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, NodePath instanceLocation) {
        if (!node.isObject()) {
            return;
        }
        this.validate(executionContext, node, rootNode, instanceLocation, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, NodePath instanceLocation, boolean walk) {
        LinkedHashSet<String> matchedInstancePropertyNames = null;
        boolean collectAnnotations = this.hasUnevaluatedPropertiesInEvaluationPath(executionContext) || this.collectAnnotations(executionContext);
        for (Map.Entry<String, Schema> entry : this.schemas.entrySet()) {
            JsonNode propertyNode = node.get(entry.getKey());
            if (propertyNode != null) {
                NodePath path = instanceLocation.append(entry.getKey());
                if (collectAnnotations) {
                    if (matchedInstancePropertyNames == null) {
                        matchedInstancePropertyNames = new LinkedHashSet<String>();
                    }
                    matchedInstancePropertyNames.add(entry.getKey());
                }
                executionContext.evaluationPathAddLast(entry.getKey());
                try {
                    if (!walk) {
                        entry.getValue().validate(executionContext, propertyNode, rootNode, path);
                        continue;
                    }
                    this.walkSchema(executionContext, entry, node, rootNode, instanceLocation, true, executionContext.getWalkConfig().getPropertyWalkHandler());
                    continue;
                }
                finally {
                    executionContext.evaluationPathRemoveLast();
                    continue;
                }
            }
            if (!walk) continue;
            executionContext.evaluationPathAddLast(entry.getKey());
            try {
                this.walkSchema(executionContext, entry, node, rootNode, instanceLocation, true, executionContext.getWalkConfig().getPropertyWalkHandler());
            }
            finally {
                executionContext.evaluationPathRemoveLast();
            }
        }
        if (collectAnnotations) {
            executionContext.getAnnotations().put(Annotation.builder().instanceLocation(instanceLocation).evaluationPath(executionContext.getEvaluationPath()).schemaLocation(this.schemaLocation).keyword(this.getKeyword()).value(matchedInstancePropertyNames == null ? Collections.emptySet() : matchedInstancePropertyNames).build());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void walk(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, NodePath instanceLocation, boolean shouldValidateSchema) {
        if (executionContext.getWalkConfig().getApplyDefaultsStrategy().shouldApplyPropertyDefaults() && null != node && node.getNodeType() == JsonNodeType.OBJECT) {
            this.applyPropertyDefaults((ObjectNode)node, executionContext);
        }
        if (shouldValidateSchema) {
            this.validate(executionContext, node == null ? MissingNode.getInstance() : node, rootNode, instanceLocation, true);
        } else {
            WalkHandler propertyWalkHandler = executionContext.getWalkConfig().getPropertyWalkHandler();
            for (Map.Entry<String, Schema> entry : this.schemas.entrySet()) {
                executionContext.evaluationPathAddLast(entry.getKey());
                try {
                    this.walkSchema(executionContext, entry, node, rootNode, instanceLocation, shouldValidateSchema, propertyWalkHandler);
                }
                finally {
                    executionContext.evaluationPathRemoveLast();
                }
            }
        }
    }

    private void applyPropertyDefaults(ObjectNode node, ExecutionContext executionContext) {
        for (Map.Entry<String, Schema> entry : this.schemas.entrySet()) {
            boolean applyDefault;
            JsonNode propertyNode = node.get(entry.getKey());
            JsonNode defaultNode = PropertiesValidator.getDefaultNode(entry.getValue(), executionContext);
            if (defaultNode == null || !(applyDefault = propertyNode == null || propertyNode.isNull() && executionContext.getWalkConfig().getApplyDefaultsStrategy().shouldApplyPropertyDefaultsIfNull())) continue;
            node.set(entry.getKey(), defaultNode);
        }
    }

    private static JsonNode getDefaultNode(Schema schema, ExecutionContext executionContext) {
        SchemaRef schemaRef;
        JsonNode result = schema.getSchemaNode().get("default");
        if (result == null && (schemaRef = SchemaRefs.from(schema, executionContext)) != null) {
            result = PropertiesValidator.getDefaultNode(schemaRef.getSchema(), executionContext);
        }
        return result;
    }

    private void walkSchema(ExecutionContext executionContext, Map.Entry<String, Schema> entry, JsonNode node, JsonNode rootNode, NodePath instanceLocation, boolean shouldValidateSchema, WalkHandler propertyWalkHandler) {
        Schema propertySchema = entry.getValue();
        JsonNode propertyNode = node == null ? null : node.get(entry.getKey());
        NodePath path = instanceLocation.append(entry.getKey());
        boolean executeWalk = propertyWalkHandler.preWalk(executionContext, KeywordType.PROPERTIES.getValue(), propertyNode, rootNode, path, propertySchema, this);
        if (propertyNode == null && node != null) {
            propertyNode = node.get(entry.getKey());
        }
        int currentErrors = executionContext.getErrors().size();
        if (executeWalk) {
            propertySchema.walk(executionContext, propertyNode, rootNode, path, shouldValidateSchema);
        }
        propertyWalkHandler.postWalk(executionContext, KeywordType.PROPERTIES.getValue(), propertyNode, rootNode, path, propertySchema, this, executionContext.getErrors().subList(currentErrors, executionContext.getErrors().size()));
    }

    public Map<String, Schema> getSchemas() {
        return this.schemas;
    }

    @Override
    public void preloadSchema() {
        this.preloadSchemas(this.schemas.values());
    }
}

