/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.Schema;
import com.networknt.schema.SchemaContext;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.keyword.BaseKeywordValidator;
import com.networknt.schema.keyword.KeywordType;
import com.networknt.schema.path.NodePath;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DependentSchemas
extends BaseKeywordValidator {
    private final Map<String, Schema> schemaDependencies = new HashMap<String, Schema>();

    public DependentSchemas(SchemaLocation schemaLocation, JsonNode schemaNode, Schema parentSchema, SchemaContext schemaContext) {
        super(KeywordType.DEPENDENT_SCHEMAS, schemaNode, schemaLocation, parentSchema, schemaContext);
        Iterator<String> it = schemaNode.fieldNames();
        while (it.hasNext()) {
            String pname = it.next();
            JsonNode pvalue = schemaNode.get(pname);
            if (!pvalue.isObject() && !pvalue.isBoolean()) continue;
            this.schemaDependencies.put(pname, schemaContext.newSchema(schemaLocation.append(pname), pvalue, parentSchema));
        }
    }

    @Override
    public void validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, NodePath instanceLocation) {
        this.validate(executionContext, node, rootNode, instanceLocation, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, NodePath instanceLocation, boolean walk) {
        Iterator<String> it = node.fieldNames();
        while (it.hasNext()) {
            String pname = it.next();
            Schema schema = this.schemaDependencies.get(pname);
            if (schema == null) continue;
            executionContext.evaluationPathAddLast(pname);
            try {
                if (!walk) {
                    schema.validate(executionContext, node, rootNode, instanceLocation);
                    continue;
                }
                schema.walk(executionContext, node, rootNode, instanceLocation, true);
            }
            finally {
                executionContext.evaluationPathRemoveLast();
            }
        }
    }

    @Override
    public void preloadSchema() {
        this.preloadSchemas(this.schemaDependencies.values());
    }

    @Override
    public void walk(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, NodePath instanceLocation, boolean shouldValidateSchema) {
        if (shouldValidateSchema) {
            this.validate(executionContext, node, rootNode, instanceLocation, true);
            return;
        }
        for (Schema schema : this.schemaDependencies.values()) {
            schema.walk(executionContext, node, rootNode, instanceLocation, false);
        }
    }
}

