/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.xml.checks.spring;

import java.util.stream.IntStream;
import javax.xml.xpath.XPathExpression;
import org.sonar.check.Rule;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;
import org.sonarsource.analyzer.commons.xml.XmlFile;
import org.sonarsource.analyzer.commons.xml.checks.SimpleXPathBasedCheck;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

@Rule(key="S3438")
@DeprecatedRuleKey(repositoryKey="java", ruleKey="S3438")
public class SingleConnectionFactoryCheck
extends SimpleXPathBasedCheck {
    private XPathExpression singleConnectionFactoryBeansExpression = this.getXPathExpression("beans/bean[@class='org.springframework.jms.connection.SingleConnectionFactory']");
    private XPathExpression reconnectOnExceptionPropertyExpression = this.getXPathExpression("property[@name='reconnectOnException']");
    private XPathExpression valueExpression = this.getXPathExpression("value[text()='true']");

    @Override
    public void scanFile(XmlFile file) {
        this.evaluateAsList(this.singleConnectionFactoryBeansExpression, file.getNamespaceUnawareDocument()).forEach(bean -> {
            if (!SingleConnectionFactoryCheck.hasAttributeValue(bean, "p:reconnectOnException") && !this.hasPropertyAsChild((Node)bean, this.reconnectOnExceptionPropertyExpression)) {
                this.reportIssue((Node)bean, "Add a \"reconnectOnException\" property, set to \"true\"");
            }
        });
    }

    private static boolean hasAttributeValue(Node bean, String attributeName) {
        NamedNodeMap attributes = bean.getAttributes();
        return IntStream.range(0, attributes.getLength()).mapToObj(attributes::item).anyMatch(attribute -> attribute.getNodeName().endsWith(attributeName) && "true".equals(attribute.getNodeValue()));
    }

    private boolean hasPropertyAsChild(Node bean, XPathExpression expression) {
        return this.evaluateAsList(expression, bean).stream().anyMatch(property -> SingleConnectionFactoryCheck.hasAttributeValue(property, "value") || this.evaluate(this.valueExpression, (Node)property).getLength() > 0);
    }
}

