/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.xml.checks.security.web;

import java.util.HashSet;
import java.util.Optional;
import javax.xml.xpath.XPathExpression;
import org.sonar.check.Rule;
import org.sonar.plugins.xml.checks.security.web.BaseWebCheck;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;
import org.sonarsource.analyzer.commons.xml.XmlFile;
import org.w3c.dom.Node;

@Rule(key="S3355")
@DeprecatedRuleKey(repositoryKey="java", ruleKey="S3355")
public class ValidationFiltersCheck
extends BaseWebCheck {
    private XPathExpression filterNamesFromFilterExpression = this.getXPathExpression("web-app/filter/filter-name");
    private XPathExpression filterNamesFromFilterMappingExpression = this.getXPathExpression("web-app/filter-mapping/filter-name");

    @Override
    public void scanWebXml(XmlFile file) {
        HashSet filtersInMapping = new HashSet();
        this.evaluateAsList(this.filterNamesFromFilterMappingExpression, file.getNamespaceUnawareDocument()).forEach(node -> ValidationFiltersCheck.getStringValue(node).ifPresent(filtersInMapping::add));
        this.evaluateAsList(this.filterNamesFromFilterExpression, file.getNamespaceUnawareDocument()).forEach(node -> {
            Optional<String> filterName = ValidationFiltersCheck.getStringValue(node);
            if (filterName.isPresent() && !filtersInMapping.contains(filterName.get())) {
                this.reportIssue((Node)node, "\"" + filterName.get() + "\" should have a mapping.");
            }
        });
    }

    private static Optional<String> getStringValue(Node node) {
        Node firstChild = node.getFirstChild();
        if (firstChild == null) {
            return Optional.empty();
        }
        return Optional.of(firstChild.getNodeValue());
    }
}

