/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.xml.checks.security.web;

import java.util.Optional;
import java.util.stream.Stream;
import javax.xml.xpath.XPathExpression;
import org.sonar.check.Rule;
import org.sonar.plugins.xml.checks.security.web.BaseWebCheck;
import org.sonarsource.analyzer.commons.xml.XPathBuilder;
import org.sonarsource.analyzer.commons.xml.XmlFile;
import org.w3c.dom.Node;

@Rule(key="S5344")
public class PasswordsInWebConfigCheck
extends BaseWebCheck {
    private final XPathExpression credentialsExpression = XPathBuilder.forExpression("//credentials").build();

    @Override
    protected void scanWebConfig(XmlFile file) {
        this.evaluateAsList(this.credentialsExpression, file.getDocument()).stream().flatMap(PasswordsInWebConfigCheck::getSensitivePasswordFormat).forEach(node -> this.reportIssue((Node)node, "Passwords should not be stored in plain text."));
    }

    private static Stream<Node> getSensitivePasswordFormat(Node node) {
        return Optional.ofNullable(node.getAttributes().getNamedItem("passwordFormat")).filter(attr -> "clear".equalsIgnoreCase(attr.getNodeValue())).stream();
    }
}

