/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.xml.checks.security.web;

import java.util.Collections;
import javax.xml.xpath.XPathExpression;
import org.sonar.check.Rule;
import org.sonar.plugins.xml.checks.security.web.BaseWebCheck;
import org.sonarsource.analyzer.commons.xml.XPathBuilder;
import org.sonarsource.analyzer.commons.xml.XmlFile;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@Rule(key="S5734")
public class MimeNosniffCheck
extends BaseWebCheck {
    private final XPathExpression httpCookiesExpression = XPathBuilder.forExpression("/configuration/system.webServer/httpProtocol/customHeaders/add[@name=\"X-Content-Type-Options\" and @value=\"nosniff\"]").build();
    private final XPathExpression reportNodeExpression = XPathBuilder.forExpression(this.getDeepestExistingNode("configuration", "system.webServer", "httpProtocol", "customHeaders")).build();

    @Override
    protected void scanWebConfig(XmlFile file) {
        Document document = file.getDocument();
        NodeList expectedNodes = this.evaluate(this.httpCookiesExpression, document);
        if (expectedNodes != null && expectedNodes.getLength() == 0) {
            this.evaluateAsList(this.reportNodeExpression, document).stream().findFirst().ifPresent(target -> this.reportIssue(XmlFile.nameLocation((Element)target), "Set the \"X-Content-Type-Options\" HTTP header to \"nosniff\" to mitigate MIME Confusion Attacks.", Collections.emptyList()));
        }
    }
}

