/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.xml.checks.security.web;

import java.util.Collections;
import java.util.List;
import javax.xml.xpath.XPathExpression;
import org.sonar.check.Rule;
import org.sonar.plugins.xml.checks.security.web.BaseWebCheck;
import org.sonarsource.analyzer.commons.xml.XPathBuilder;
import org.sonarsource.analyzer.commons.xml.XmlFile;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Rule(key="S3330")
public class HttpOnlyOnCookiesCheck
extends BaseWebCheck {
    private final XPathExpression sessionConfigCookieConfigExpression = XPathBuilder.forExpression("/n:web-app/n:session-config/n:cookie-config").withNamespace("n", "http://xmlns.jcp.org/xml/ns/javaee").build();
    private final XPathExpression httpOnlyExpression = XPathBuilder.forExpression("n:http-only").withNamespace("n", "http://xmlns.jcp.org/xml/ns/javaee").build();
    private final XPathExpression httpCookiesExpression = XPathBuilder.forExpression("/configuration/system.web/httpCookies[@httpOnlyCookies=\"true\"]").build();
    private final XPathExpression reportNodeExpression = XPathBuilder.forExpression(this.getDeepestExistingNode("configuration", "system.web", "httpCookies")).build();

    @Override
    protected void scanWebXml(XmlFile file) {
        this.evaluateAsList(this.sessionConfigCookieConfigExpression, file.getDocument()).forEach(this::checkHttpOnly);
    }

    @Override
    protected void scanWebConfig(XmlFile file) {
        Document document = file.getDocument();
        NodeList httpCookiesNodes = this.evaluate(this.httpCookiesExpression, document);
        if (httpCookiesNodes != null && httpCookiesNodes.getLength() == 0) {
            this.evaluateAsList(this.reportNodeExpression, document).stream().findFirst().ifPresent(target -> this.reportIssue(XmlFile.nameLocation((Element)target), "Global <httpCookies> tag is missing or its 'httpOnlyCookies' attribute is not set to true.", Collections.emptyList()));
        }
    }

    private void checkHttpOnly(Node cookieConfig) {
        List<Node> httpOnlyNodes = this.evaluateAsList(this.httpOnlyExpression, cookieConfig);
        if (httpOnlyNodes.isEmpty()) {
            this.reportIssue(cookieConfig, "<http-only> tag is missing and should be set to true.");
        } else {
            httpOnlyNodes.stream().filter(HttpOnlyOnCookiesCheck::isNotSetToTrue).forEach(this::reportWrongValue);
        }
    }

    private static boolean isNotSetToTrue(Node node) {
        return !"true".equals(node.getTextContent());
    }

    private void reportWrongValue(Node node) {
        this.reportIssue(node, "<http-only> tag should be set to true.");
    }
}

