/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.xml.checks.security.web;

import java.util.regex.Pattern;
import javax.xml.xpath.XPathExpression;
import org.sonar.check.Rule;
import org.sonar.plugins.xml.checks.security.web.BaseWebCheck;
import org.sonarsource.analyzer.commons.xml.XPathBuilder;
import org.sonarsource.analyzer.commons.xml.XmlFile;
import org.w3c.dom.Node;

@Rule(key="S5122")
public class CrossOriginResourceSharingCheck
extends BaseWebCheck {
    private static final Pattern STAR_IN_COMMA_SEPARATED_LIST_REGEX = Pattern.compile("(^|,)\\*(,|$)");
    private XPathExpression corsAllowedOrigins = XPathBuilder.forExpression("/j:web-app/j:filter[j:filter-class='org.apache.catalina.filters.CorsFilter']/j:init-param[j:param-name='cors.allowed.origins']/j:param-value/text()").withNamespace("j", "http://xmlns.jcp.org/xml/ns/javaee").build();

    @Override
    protected void scanWebXml(XmlFile file) {
        this.evaluateAsList(this.corsAllowedOrigins, file.getDocument()).stream().filter(node -> STAR_IN_COMMA_SEPARATED_LIST_REGEX.matcher(node.getNodeValue()).find()).forEach(node -> this.reportIssue((Node)node, "Make sure this permissive CORS policy is safe here."));
    }
}

