/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.xml.checks.security.web;

import org.sonar.plugins.xml.Xml;
import org.sonarsource.analyzer.commons.xml.XmlFile;
import org.sonarsource.analyzer.commons.xml.checks.SimpleXPathBasedCheck;

public class BaseWebCheck
extends SimpleXPathBasedCheck {
    protected static final String WEB_XML_ROOT = "web-app";

    @Override
    public final void scanFile(XmlFile file) {
        if (BaseWebCheck.isWebXmlFile(file)) {
            this.scanWebXml(file);
        } else if (Xml.isDotNetApplicationConfig(file.getInputFile())) {
            this.scanWebConfig(file);
        }
    }

    protected void scanWebXml(XmlFile file) {
    }

    protected void scanWebConfig(XmlFile file) {
    }

    private static boolean isWebXmlFile(XmlFile file) {
        return "web.xml".equalsIgnoreCase(file.getInputFile().filename());
    }

    protected String getDeepestExistingNode(String ... segments) {
        StringBuilder expression = new StringBuilder();
        for (int len = segments.length; len > 0; --len) {
            for (int i = 0; i < len; ++i) {
                expression.append("/").append(segments[i]);
            }
            if (len < segments.length) {
                expression.append("[not(").append(segments[len]).append(")]");
            }
            if (len <= 1) continue;
            expression.append("|");
        }
        return expression.toString();
    }
}

