/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.xml.checks.security.android;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.xpath.XPathExpression;
import org.sonar.check.Rule;
import org.sonar.plugins.xml.checks.security.android.AbstractAndroidManifestCheck;
import org.sonarsource.analyzer.commons.xml.XPathBuilder;
import org.sonarsource.analyzer.commons.xml.XmlFile;
import org.sonarsource.analyzer.commons.xml.checks.SonarXmlCheck;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

@Rule(key="S6361")
public class AndroidProviderPermissionCheck
extends AbstractAndroidManifestCheck {
    private static final String MESSAGE = "Make sure using a single permission for read and write is safe here.";
    private final XPathExpression xPathExpression = XPathBuilder.forExpression("/manifest/application/provider[ (@n:permission and not(@n:readPermission) and not(@n:writePermission))or (@n:permission and @n:readPermission and not(@n:writePermission) and @n:permission = @n:readPermission)or (@n:permission and not(@n:readPermission) and @n:writePermission and @n:permission = @n:writePermission)or (@n:readPermission and @n:writePermission and @n:readPermission = @n:writePermission)]").withNamespace("n", "http://schemas.android.com/apk/res/android").build();

    @Override
    protected final void scanAndroidManifest(XmlFile file) {
        this.evaluateAsList(this.xPathExpression, file.getDocument()).forEach(node -> {
            NamedNodeMap attributes = node.getAttributes();
            List nodes = Stream.of("readPermission", "writePermission", "permission").map(s -> attributes.getNamedItemNS("http://schemas.android.com/apk/res/android", (String)s)).filter(Objects::nonNull).collect(Collectors.toList());
            this.reportIssue(XmlFile.nodeLocation((Node)nodes.get(0)), MESSAGE, nodes.size() > 1 ? Collections.singletonList(new SonarXmlCheck.Secondary((Node)nodes.get(1), null)) : Collections.emptyList());
        });
    }
}

