/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.xml.checks.security.android;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.xpath.XPathExpression;
import org.sonar.check.Rule;
import org.sonar.plugins.xml.checks.security.android.AbstractAndroidManifestCheck;
import org.sonarsource.analyzer.commons.xml.XPathBuilder;
import org.sonarsource.analyzer.commons.xml.XmlFile;
import org.w3c.dom.Node;

@Rule(key="S5604")
public class AndroidPermissionsCheck
extends AbstractAndroidManifestCheck {
    private static final String MESSAGE = "Make sure the use of \"%s\" permission is necessary.";
    private final XPathExpression xPathExpression = XPathBuilder.forExpression("/manifest/uses-permission").build();
    private static final Set<String> DANGEROUS_PERMISSIONS = new HashSet<String>(Arrays.asList("android.permission.ACCEPT_HANDOVER", "android.permission.ACCESS_BACKGROUND_LOCATION", "android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION", "android.permission.ACCESS_MEDIA_LOCATION", "android.permission.ACTIVITY_RECOGNITION", "com.android.voicemail.permission.ADD_VOICEMAIL", "android.permission.ANSWER_PHONE_CALLS", "android.permission.BODY_SENSORS", "android.permission.CALL_PHONE", "android.permission.CAMERA", "android.permission.GET_ACCOUNTS", "android.permission.PROCESS_OUTGOING_CALLS", "android.permission.READ_CALENDAR", "android.permission.READ_CALL_LOG", "android.permission.READ_CONTACTS", "android.permission.READ_EXTERNAL_STORAGE", "android.permission.READ_PHONE_NUMBERS", "android.permission.READ_PHONE_STATE", "android.permission.READ_SMS", "android.permission.RECEIVE_MMS", "android.permission.RECEIVE_SMS", "android.permission.RECEIVE_WAP_PUSH", "android.permission.RECORD_AUDIO", "android.permission.SEND_SMS", "android.permission.USE_SIP", "android.permission.WRITE_CALENDAR", "android.permission.WRITE_CALL_LOG", "android.permission.WRITE_CONTACTS", "android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.ACCESS_CHECKIN_PROPERTIES", "android.permission.ACCOUNT_MANAGER", "android.permission.BIND_APPWIDGET", "android.permission.BLUETOOTH_PRIVILEGED", "android.permission.BROADCAST_PACKAGE_REMOVED", "android.permission.BROADCAST_SMS", "android.permission.BROADCAST_WAP_PUSH", "android.permission.CALL_PRIVILEGED", "android.permission.CAPTURE_AUDIO_OUTPUT", "android.permission.CHANGE_COMPONENT_ENABLED_STATE", "android.permission.CONTROL_LOCATION_UPDATES", "android.permission.DELETE_PACKAGES", "android.permission.DIAGNOSTIC", "android.permission.DUMP", "android.permission.FACTORY_TEST", "android.permission.INSTALL_LOCATION_PROVIDER", "android.permission.INSTALL_PACKAGES", "android.permission.LOCATION_HARDWARE", "android.permission.MASTER_CLEAR", "android.permission.MODIFY_PHONE_STATE", "android.permission.MOUNT_FORMAT_FILESYSTEMS", "android.permission.MOUNT_UNMOUNT_FILESYSTEMS", "android.permission.READ_INPUT_STATE", "android.permission.REBOOT", "android.permission.SEND_RESPOND_VIA_MESSAGE", "android.permission.SET_ALWAYS_FINISH", "android.permission.SET_ANIMATION_SCALE", "android.permission.SET_DEBUG_APP", "android.permission.SET_PROCESS_LIMIT", "android.permission.SET_TIME", "android.permission.SET_TIME_ZONE", "android.permission.SIGNAL_PERSISTENT_PROCESSES", "android.permission.STATUS_BAR", "android.permission.UPDATE_DEVICE_STATS", "android.permission.WRITE_APN_SETTINGS", "android.permission.WRITE_GSERVICES", "android.permission.WRITE_SECURE_SETTINGS"));

    @Override
    protected final void scanAndroidManifest(XmlFile file) {
        List<Node> usesPermissionNodes = this.evaluateAsList(this.xPathExpression, file.getDocument());
        if (!AndroidPermissionsCheck.hasToolsNodeRemoveAll(usesPermissionNodes)) {
            usesPermissionNodes.forEach(this::checkAndReportPermissionIssue);
        }
    }

    private void checkAndReportPermissionIssue(Node node) {
        Node permissionsAttribute = AndroidPermissionsCheck.findPermissionAttribute(node);
        String permissionValue = permissionsAttribute.getNodeValue();
        if (!AndroidPermissionsCheck.hasToolsNodeValue(node, "remove") && DANGEROUS_PERMISSIONS.contains(permissionValue)) {
            this.reportIssue(permissionsAttribute, String.format(MESSAGE, AndroidPermissionsCheck.simpleName(permissionValue)));
        }
    }

    private static String simpleName(String fullyQualifiedName) {
        return fullyQualifiedName.substring(fullyQualifiedName.lastIndexOf(46) + 1);
    }

    private static Node findPermissionAttribute(Node node) {
        return node.getAttributes().getNamedItemNS("http://schemas.android.com/apk/res/android", "name");
    }

    private static boolean hasToolsNodeValue(Node node, String value) {
        Node toolsNodeAttribute = node.getAttributes().getNamedItemNS("http://schemas.android.com/tools", "node");
        return toolsNodeAttribute != null && value.equals(toolsNodeAttribute.getNodeValue());
    }

    private static boolean hasToolsNodeRemoveAll(List<Node> permissionNodes) {
        return permissionNodes.stream().anyMatch(node -> AndroidPermissionsCheck.hasToolsNodeValue(node, "removeAll"));
    }
}

