/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.xml.checks.security.android;

import java.util.Collections;
import javax.xml.xpath.XPathExpression;
import org.sonar.check.Rule;
import org.sonar.plugins.xml.checks.security.android.AbstractAndroidManifestCheck;
import org.sonarsource.analyzer.commons.xml.XPathBuilder;
import org.sonarsource.analyzer.commons.xml.XmlFile;
import org.w3c.dom.Element;

@Rule(key="S7207")
public class AndroidComponentWithIntentFilterExportedCheck
extends AbstractAndroidManifestCheck {
    private static final String MESSAGE = "Mark this component as exported.";
    private final XPathExpression xPathExpression = XPathBuilder.forExpression("/manifest/application/*[ (self::activity or self::activity-alias or self::provider or self::receiver or self::service)and (intent-filter)and (not(@n:exported))]").withNamespace("n", "http://schemas.android.com/apk/res/android").build();

    @Override
    protected void scanAndroidManifest(XmlFile file) {
        this.evaluateAsList(this.xPathExpression, file.getDocument()).forEach(node -> this.reportIssue(XmlFile.nameLocation((Element)node), MESSAGE, Collections.emptyList()));
    }
}

