/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.xml.checks.security.android;

import java.util.Collections;
import java.util.List;
import javax.xml.xpath.XPathExpression;
import org.sonar.check.Rule;
import org.sonar.plugins.xml.checks.security.android.AbstractAndroidManifestCheck;
import org.sonarsource.analyzer.commons.xml.XPathBuilder;
import org.sonarsource.analyzer.commons.xml.XmlFile;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Rule(key="S6358")
public class AndroidApplicationBackupCheck
extends AbstractAndroidManifestCheck {
    private static final String ANDROID_MIN_SDK_VERSION = "sonar.android.minsdkversion.min";
    private static final String MESSAGE = "Make sure backup of application data is safe here.";
    private static final String BASE_XPATH_QUERY = "/manifest/application[ not(@n:allowBackup='false')and not(@n:backupAgent)%s]";
    private static final String APPLICATION_WITH_BACKUP_QUERY = String.format("/manifest/application[ not(@n:allowBackup='false')and not(@n:backupAgent)%s]", "and not(@n:fullBackupContent and (starts-with(@n:fullBackupContent, '@') or starts-with(@n:fullBackupContent, '$')))");
    private static final String APPLICATION_BELOW_SDK_23_QUERY = String.format("/manifest/application[ not(@n:allowBackup='false')and not(@n:backupAgent)%s]", "");
    private static final XPathExpression X_PATH_APPLICATION_WITH_BACKUP = XPathBuilder.forExpression(APPLICATION_WITH_BACKUP_QUERY).withNamespace("n", "http://schemas.android.com/apk/res/android").build();
    private static final XPathExpression X_PATH_APPLICATION_BELOW_SDK_23 = XPathBuilder.forExpression(APPLICATION_BELOW_SDK_23_QUERY).withNamespace("n", "http://schemas.android.com/apk/res/android").build();

    @Override
    protected void scanAndroidManifest(XmlFile file) {
        Integer minSdkVersion = this.getContext().config().getInt(ANDROID_MIN_SDK_VERSION).orElse(null);
        List<Node> nodes = minSdkVersion != null && minSdkVersion < 23 ? this.evaluateAsList(X_PATH_APPLICATION_BELOW_SDK_23, file.getDocument()) : this.evaluateAsList(X_PATH_APPLICATION_WITH_BACKUP, file.getDocument());
        nodes.forEach(node -> this.reportIssue(XmlFile.nameLocation((Element)node), MESSAGE, Collections.emptyList()));
    }
}

