/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.xml.checks.maven.helpers;

import org.sonar.plugins.xml.checks.maven.helpers.PatternMatcher;
import org.sonar.plugins.xml.checks.maven.helpers.RangedVersionMatcher;
import org.sonar.plugins.xml.checks.maven.helpers.StringMatcher;

public class MavenDependencyMatcher {
    private static final StringMatcher ALWAYS_MATCHING_MATCHER = StringMatcher.any();
    private final StringMatcher groupIdMatcher;
    private final StringMatcher artifactIdMatcher;
    private final StringMatcher versionMatcher;

    public MavenDependencyMatcher(String dependencyName, String version) {
        try {
            String[] name = dependencyName.split(":", -1);
            if (name.length == 1) {
                throw new IllegalArgumentException("Missing ':' separator.");
            }
            if (name.length > 2) {
                throw new IllegalArgumentException("Only one ':' separator expected.");
            }
            this.groupIdMatcher = MavenDependencyMatcher.getMatcherForPattern(name[0].trim());
            this.artifactIdMatcher = MavenDependencyMatcher.getMatcherForPattern(name[1].trim());
        }
        catch (RuntimeException ex) {
            throw new IllegalArgumentException("Invalid DependencyName pattern '" + dependencyName + "'. Should match '[groupId]:[artifactId]', you can use '*' as wildcard or a regular expression. Error: " + ex.getMessage());
        }
        try {
            this.versionMatcher = MavenDependencyMatcher.getMatcherForVersion(version);
        }
        catch (RuntimeException ex) {
            throw new IllegalArgumentException("Invalid Version pattern '" + version + "'. Leave blank for all versions. You can use '*' as wildcard and '-' as range like '1.0-3.1' or '*-3.1'. Error: " + ex.getMessage());
        }
    }

    private static StringMatcher getMatcherForPattern(String pattern) {
        return StringMatcher.isBlank(pattern) || StringMatcher.isWildCard(pattern) ? ALWAYS_MATCHING_MATCHER : new PatternMatcher(pattern);
    }

    private static StringMatcher getMatcherForVersion(String version) {
        if (version.contains("-")) {
            String[] bounds = version.split("-", -1);
            return new RangedVersionMatcher(bounds[0], bounds[1]);
        }
        return MavenDependencyMatcher.getMatcherForPattern(version);
    }

    public boolean matches(String groupId, String artifactId, String version) {
        return this.groupIdMatcher.test(groupId) && this.artifactIdMatcher.test(artifactId) && this.versionMatcher.test(version);
    }
}

