/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.xml.checks;

import java.util.Collections;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.xml.Utils;
import org.sonarsource.analyzer.commons.xml.XmlFile;
import org.sonarsource.analyzer.commons.xml.XmlTextRange;
import org.sonarsource.analyzer.commons.xml.checks.SonarXmlCheck;

@Rule(key="S103")
public class LineLengthCheck
extends SonarXmlCheck {
    public static final String RULE_KEY = "S103";
    private static final int DEFAULT_LENGTH = 120;
    @RuleProperty(key="maximumLineLength", description="The maximum authorized line length", defaultValue="120", type="INTEGER")
    private int maximumLineLength = 120;
    private static final Pattern RTRIM = Pattern.compile("\\s+$");

    public void setMaximumLineLength(int maximumLineLength) {
        this.maximumLineLength = maximumLineLength;
    }

    @Override
    public void scanFile(XmlFile file) {
        int lineNumber = 1;
        for (String line : Utils.splitLines(file.getContents())) {
            String trimLine = LineLengthCheck.trimEndOfLine(line);
            int length = trimLine.length();
            if (length > this.maximumLineLength) {
                XmlTextRange textRange = new XmlTextRange(lineNumber, 0, lineNumber, trimLine.length());
                this.reportIssue(textRange, String.format("Split this %d characters long line (which is greater than %d authorized).", length, this.maximumLineLength), Collections.emptyList());
            }
            ++lineNumber;
        }
    }

    private static String trimEndOfLine(String line) {
        return RTRIM.matcher(line).replaceAll("");
    }
}

