/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.xml;

import java.util.ArrayList;
import java.util.List;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.highlighting.NewHighlighting;
import org.sonar.api.batch.sensor.highlighting.TypeOfText;
import org.sonar.plugins.xml.Utils;
import org.sonarsource.analyzer.commons.xml.PrologElement;
import org.sonarsource.analyzer.commons.xml.XmlFile;
import org.sonarsource.analyzer.commons.xml.XmlTextRange;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlHighlighting {
    private final XmlFile xmlFile;
    private NewHighlighting highlighting;

    private XmlHighlighting(XmlFile xmlFile) {
        this.xmlFile = xmlFile;
    }

    public static void highlight(SensorContext context, XmlFile xmlFile) {
        new XmlHighlighting(xmlFile).highlight(context);
    }

    private void highlight(SensorContext context) {
        this.highlighting = context.newHighlighting().onFile(this.xmlFile.getInputFile());
        this.xmlFile.getPrologElement().ifPresent(this::highlightProlog);
        XmlHighlighting.children(this.xmlFile.getDocument()).forEach(this::highlightNode);
        this.highlighting.save();
    }

    private void highlightNode(Node node) {
        switch (node.getNodeType()) {
            case 1: {
                this.highlightElementNode(node);
                break;
            }
            case 4: {
                this.addHighlighting(XmlFile.startLocation((CDATASection)node), TypeOfText.KEYWORD);
                this.addHighlighting(XmlFile.endLocation((CDATASection)node), TypeOfText.KEYWORD);
                break;
            }
            case 8: 
            case 10: {
                this.addHighlighting(XmlFile.nodeLocation(node), TypeOfText.STRUCTURED_COMMENT);
                break;
            }
        }
    }

    private void highlightElementNode(Node node) {
        XmlTextRange nameLocation = XmlFile.nameLocation((Element)node);
        XmlTextRange startLocation = XmlFile.startLocation((Element)node);
        XmlTextRange endLocation = XmlFile.endLocation((Element)node);
        this.addHighlighting(new XmlTextRange(startLocation, nameLocation), TypeOfText.KEYWORD);
        NamedNodeMap attributes = node.getAttributes();
        XmlTextRange lastLocation = nameLocation;
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            this.addHighlighting(XmlFile.attributeNameLocation(attribute), TypeOfText.CONSTANT);
            XmlTextRange valueLocation = XmlFile.attributeValueLocation(attribute);
            this.addHighlighting(valueLocation, TypeOfText.STRING);
            lastLocation = valueLocation;
        }
        if (Utils.isSelfClosing((Element)node)) {
            XmlTextRange textRange = new XmlTextRange(lastLocation.getEndLine(), lastLocation.getEndColumn(), endLocation.getEndLine(), endLocation.getEndColumn());
            this.addHighlighting(textRange, TypeOfText.KEYWORD);
        } else {
            XmlTextRange textRange = new XmlTextRange(lastLocation.getEndLine(), lastLocation.getEndColumn(), startLocation.getEndLine(), startLocation.getEndColumn());
            this.addHighlighting(textRange, TypeOfText.KEYWORD);
            XmlHighlighting.children(node).forEach(this::highlightNode);
            this.addHighlighting(endLocation, TypeOfText.KEYWORD);
        }
    }

    private static List<Node> children(Node node) {
        NodeList childNodes = node.getChildNodes();
        ArrayList<Node> result = new ArrayList<Node>();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            result.add(childNodes.item(i));
        }
        return result;
    }

    private void highlightProlog(PrologElement prologElement) {
        this.addHighlighting(prologElement.getPrologStartLocation(), TypeOfText.KEYWORD);
        prologElement.getAttributes().forEach(prologAttribute -> {
            this.addHighlighting(prologAttribute.getNameLocation(), TypeOfText.CONSTANT);
            this.addHighlighting(prologAttribute.getValueLocation(), TypeOfText.STRING);
        });
        this.addHighlighting(prologElement.getPrologEndLocation(), TypeOfText.KEYWORD);
    }

    private void addHighlighting(XmlTextRange textRange, TypeOfText typeOfText) {
        this.highlighting.highlight(textRange.getStartLine(), textRange.getStartColumn(), textRange.getEndLine(), textRange.getEndColumn(), typeOfText);
    }
}

