/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.xml;

import java.util.ArrayList;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.config.Configuration;
import org.sonar.api.resources.AbstractLanguage;

public class Xml
extends AbstractLanguage {
    private static final String[] DEFAULT_SUFFIXES = new String[]{".xml"};
    public static final String KEY = "xml";
    private static final String XML_LANGUAGE_NAME = "XML";
    public static final String XML_RESOURCE_PATH = "org/sonar/l10n/xml/rules/xml";
    public static final String REPOSITORY_KEY = "xml";
    public static final String REPOSITORY_NAME = "SonarAnalyzer";
    public static final String SONAR_WAY_PROFILE_NAME = "Sonar way";
    public static final String SONAR_WAY_PATH = "org/sonar/l10n/xml/rules/xml/Sonar_way_profile.json";
    private Configuration configuration;

    public Xml(Configuration configuration) {
        super("xml", XML_LANGUAGE_NAME);
        this.configuration = configuration;
    }

    public String[] getFileSuffixes() {
        String[] suffixes = Xml.filterEmptyStrings(this.configuration.getStringArray("sonar.xml.file.suffixes"));
        if (suffixes.length == 0) {
            suffixes = DEFAULT_SUFFIXES;
        }
        return suffixes;
    }

    private static String[] filterEmptyStrings(String[] stringArray) {
        ArrayList<String> nonEmptyStrings = new ArrayList<String>();
        for (String string : stringArray) {
            if (string.trim().isEmpty()) continue;
            nonEmptyStrings.add(string.trim());
        }
        return nonEmptyStrings.toArray(new String[nonEmptyStrings.size()]);
    }

    public static boolean isConfigFile(InputFile inputFile) {
        return inputFile.filename().endsWith(".config");
    }

    public static boolean isDotNetApplicationConfig(InputFile inputFile) {
        String filename = inputFile.filename();
        return "web.config".equalsIgnoreCase(filename) || "machine.config".equalsIgnoreCase(filename);
    }
}

