/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.utils;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonarsource.slang.api.AssignmentExpressionTree;
import org.sonarsource.slang.api.BinaryExpressionTree;
import org.sonarsource.slang.api.IdentifierTree;
import org.sonarsource.slang.api.JumpTree;
import org.sonarsource.slang.api.LiteralTree;
import org.sonarsource.slang.api.LoopTree;
import org.sonarsource.slang.api.ModifierTree;
import org.sonarsource.slang.api.NativeTree;
import org.sonarsource.slang.api.Token;
import org.sonarsource.slang.api.Tree;
import org.sonarsource.slang.api.UnaryExpressionTree;
import org.sonarsource.slang.api.VariableDeclarationTree;
import org.sonarsource.slang.visitors.TreePrinter;

public class SyntacticEquivalence {
    private SyntacticEquivalence() {
    }

    public static boolean areEquivalent(@Nullable List<? extends Tree> first2, @Nullable List<? extends Tree> second) {
        if (first2 == second) {
            return true;
        }
        if (first2 == null || second == null || first2.size() != second.size()) {
            return false;
        }
        for (int i2 = 0; i2 < first2.size(); ++i2) {
            if (SyntacticEquivalence.areEquivalent(first2.get(i2), second.get(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean areEquivalent(@Nullable Tree first2, @Nullable Tree second) {
        if (first2 == second) {
            return true;
        }
        if (first2 == null || second == null || !first2.getClass().equals(second.getClass())) {
            return false;
        }
        if (first2 instanceof IdentifierTree) {
            return SyntacticEquivalence.getUniqueIdentifier((IdentifierTree)first2).equals(SyntacticEquivalence.getUniqueIdentifier((IdentifierTree)second));
        }
        if (first2 instanceof LiteralTree) {
            return ((LiteralTree)first2).value().equals(((LiteralTree)second).value());
        }
        if (SyntacticEquivalence.hasDifferentFields(first2, second)) {
            return false;
        }
        if (first2 instanceof NativeTree && first2.children().isEmpty()) {
            return SyntacticEquivalence.areEquivalentTokenText(first2.metaData().tokens(), second.metaData().tokens());
        }
        return SyntacticEquivalence.areEquivalent(first2.children(), second.children());
    }

    public static String getUniqueIdentifier(IdentifierTree identifier) {
        return identifier.identifier();
    }

    private static boolean areEquivalentTokenText(List<Token> firstList, List<Token> secondList) {
        if (firstList.size() != secondList.size()) {
            return false;
        }
        for (int i2 = 0; i2 < firstList.size(); ++i2) {
            if (firstList.get(i2).text().equals(secondList.get(i2).text())) continue;
            return false;
        }
        return true;
    }

    private static boolean hasDifferentFields(Tree first2, Tree second) {
        boolean nativeTreeCheck = first2 instanceof NativeTree && !((NativeTree)first2).nativeKind().equals(((NativeTree)second).nativeKind());
        boolean unaryTreeCheck = first2 instanceof UnaryExpressionTree && ((UnaryExpressionTree)first2).operator() != ((UnaryExpressionTree)second).operator();
        boolean binaryTreeCheck = first2 instanceof BinaryExpressionTree && ((BinaryExpressionTree)first2).operator() != ((BinaryExpressionTree)second).operator();
        boolean assignTreeCheck = first2 instanceof AssignmentExpressionTree && ((AssignmentExpressionTree)first2).operator() != ((AssignmentExpressionTree)second).operator();
        boolean vardeclTreeCheck = first2 instanceof VariableDeclarationTree && ((VariableDeclarationTree)first2).isVal() != ((VariableDeclarationTree)second).isVal();
        boolean loopTreeCheck = first2 instanceof LoopTree && (((LoopTree)first2).kind() != ((LoopTree)second).kind() || !((LoopTree)first2).keyword().text().equals(((LoopTree)second).keyword().text()));
        boolean modifierTreeCheck = first2 instanceof ModifierTree && ((ModifierTree)first2).kind() != ((ModifierTree)second).kind();
        boolean jumpTreeCheck = first2 instanceof JumpTree && ((JumpTree)first2).kind() != ((JumpTree)second).kind();
        return nativeTreeCheck || unaryTreeCheck || binaryTreeCheck || assignTreeCheck || vardeclTreeCheck || loopTreeCheck || modifierTreeCheck || jumpTreeCheck;
    }

    public static List<List<Tree>> findDuplicatedGroups(List<Tree> list2) {
        return list2.stream().collect(Collectors.groupingBy(ComparableTree::new, LinkedHashMap::new, Collectors.toList())).values().stream().filter(group2 -> group2.size() > 1).toList();
    }

    static class ComparableTree {
        private final Tree tree;
        private final int hash;

        ComparableTree(Tree tree) {
            this.tree = tree;
            this.hash = ComparableTree.computeHash(tree);
        }

        private static int computeHash(@Nullable Tree tree) {
            if (tree == null) {
                return 0;
            }
            return TreePrinter.tree2string(tree).hashCode();
        }

        public boolean equals(Object other) {
            if (!(other instanceof ComparableTree)) {
                return false;
            }
            ComparableTree that = (ComparableTree)other;
            return this.hash == that.hash && SyntacticEquivalence.areEquivalent(this.tree, ((ComparableTree)other).tree);
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

