/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.plugin.caching;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.cache.ReadCache;
import org.sonar.api.batch.sensor.cache.WriteCache;
import org.sonarsource.slang.plugin.InputFileContext;

public class HashCacheUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HashCacheUtils.class);

    private HashCacheUtils() {
    }

    public static boolean hasSameHashCached(InputFileContext inputFileContext) {
        byte[] expectedHashAsBytes;
        InputFile inputFile = inputFileContext.inputFile;
        String fileKey = inputFile.key();
        if (inputFile.status() != InputFile.Status.SAME) {
            LOG.debug("File {} is considered changed: file status is {}.", (Object)fileKey, (Object)inputFile.status());
            return false;
        }
        SensorContext sensorContext = inputFileContext.sensorContext;
        if (!sensorContext.isCacheEnabled()) {
            LOG.debug("File {} is considered changed: hash cache is disabled.", (Object)fileKey);
            return false;
        }
        String hashKey = HashCacheUtils.computeKey(inputFile);
        ReadCache previousCache = sensorContext.previousCache();
        if (!previousCache.contains(hashKey)) {
            LOG.debug("File {} is considered changed: hash could not be found in the cache.", (Object)fileKey);
            return false;
        }
        try (InputStream in = previousCache.read(hashKey);){
            expectedHashAsBytes = in.readAllBytes();
        }
        catch (IOException error) {
            LOG.warn(error.getMessage(), (Throwable)error);
            LOG.debug("File {} is considered changed: failed to read hash from the cache.", (Object)fileKey);
            return false;
        }
        String expected = Hex.encodeHexString(expectedHashAsBytes);
        String actual = inputFile.md5Hash();
        boolean matchesWithCache = expected.equals(actual);
        if (matchesWithCache) {
            LOG.debug("File {} is considered unchanged.", (Object)fileKey);
        } else {
            LOG.debug("File {} is considered changed: input file hash does not match cached hash ({} vs {}).", new Object[]{fileKey, actual, expected});
        }
        return matchesWithCache;
    }

    public static boolean copyFromPrevious(InputFileContext inputFileContext) {
        if (!inputFileContext.sensorContext.isCacheEnabled()) {
            return false;
        }
        InputFile inputFile = inputFileContext.inputFile;
        String cacheKey = HashCacheUtils.computeKey(inputFile);
        WriteCache nextCache = inputFileContext.sensorContext.nextCache();
        try {
            nextCache.copyFromPrevious(cacheKey);
        }
        catch (IllegalArgumentException ignored) {
            LOG.warn("Failed to copy hash from previous analysis for {}.", (Object)inputFile.key());
            return false;
        }
        return true;
    }

    public static boolean writeHashForNextAnalysis(InputFileContext inputFileContext) {
        if (!inputFileContext.sensorContext.isCacheEnabled()) {
            return false;
        }
        InputFile inputFile = inputFileContext.inputFile;
        WriteCache nextCache = inputFileContext.sensorContext.nextCache();
        try {
            nextCache.write(HashCacheUtils.computeKey(inputFileContext.inputFile), Hex.decodeHex(inputFile.md5Hash()));
        }
        catch (IllegalArgumentException ignored) {
            LOG.warn("Failed to write hash for {} to cache.", (Object)inputFile.key());
            return false;
        }
        catch (DecoderException ignored) {
            LOG.warn("Failed to convert hash from hexadecimal string to bytes for {}.", (Object)inputFile.key());
            return false;
        }
        return true;
    }

    private static String computeKey(InputFile inputFile) {
        return "slang:hash:" + inputFile.key();
    }
}

