/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonarsource.slang.api.Annotation;
import org.sonarsource.slang.api.ClassDeclarationTree;
import org.sonarsource.slang.api.FunctionDeclarationTree;
import org.sonarsource.slang.api.ParameterTree;
import org.sonarsource.slang.api.TextRange;
import org.sonarsource.slang.api.Tree;
import org.sonarsource.slang.api.VariableDeclarationTree;
import org.sonarsource.slang.plugin.InputFileContext;
import org.sonarsource.slang.visitors.TreeVisitor;

public class IssueSuppressionVisitor
extends TreeVisitor<InputFileContext> {
    private Map<String, Set<TextRange>> filteredRules;
    private static final List<String> SUPPRESS_ANNOTATION_NAMES = Arrays.asList("Suppress", "SuppressWarnings");
    private static final Pattern LITERAL_PATTERN = Pattern.compile("\"(.*?)\"");

    public IssueSuppressionVisitor() {
        this.register(FunctionDeclarationTree.class, (ctx, tree) -> this.checkSuppressAnnotations((Tree)tree));
        this.register(ClassDeclarationTree.class, (ctx, tree) -> this.checkSuppressAnnotations((Tree)tree));
        this.register(VariableDeclarationTree.class, (ctx, tree) -> this.checkSuppressAnnotations((Tree)tree));
        this.register(ParameterTree.class, (ctx, tree) -> this.checkSuppressAnnotations((Tree)tree));
    }

    private void checkSuppressAnnotations(Tree tree) {
        List<Annotation> annotations = tree.metaData().annotations();
        TextRange textRange = tree.textRange();
        annotations.forEach(annotation -> {
            if (SUPPRESS_ANNOTATION_NAMES.contains(annotation.shortName())) {
                IssueSuppressionVisitor.getSuppressedKeys(annotation.argumentsText()).forEach(ruleKey -> this.filteredRules.computeIfAbsent((String)ruleKey, key2 -> new HashSet()).add(textRange));
            }
        });
    }

    private static Collection<String> getSuppressedKeys(List<String> argumentsText) {
        ArrayList<String> keys2 = new ArrayList<String>();
        for (String s2 : argumentsText) {
            keys2.addAll(IssueSuppressionVisitor.getArgumentsValues(s2));
        }
        return keys2;
    }

    private static Collection<String> getArgumentsValues(String argumentText) {
        ArrayList<String> values2 = new ArrayList<String>();
        Matcher m = LITERAL_PATTERN.matcher(argumentText);
        while (m.find()) {
            values2.add(m.group(1));
        }
        return values2;
    }

    @Override
    protected void before(InputFileContext ctx, Tree root) {
        this.filteredRules = new HashMap<String, Set<TextRange>>();
    }

    @Override
    protected void after(InputFileContext ctx, Tree root) {
        ctx.setFilteredRules(this.filteredRules);
    }
}

