/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.plugin;

import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.sonarsource.slang.api.Comment;
import org.sonarsource.slang.api.TextRange;

public class CommentAnalysisUtils {
    public static final String NOSONAR_PREFIX = "NOSONAR";
    private static final boolean[] IS_NON_BLANK_CHAR_IN_COMMENTS = new boolean[127];

    private CommentAnalysisUtils() {
    }

    static boolean isNosonarComment(Comment comment) {
        return comment.contentText().trim().toUpperCase(Locale.ENGLISH).startsWith(NOSONAR_PREFIX);
    }

    static Set<Integer> findNonEmptyCommentLines(TextRange range, String content) {
        HashSet<Integer> lineNumbers = new HashSet<Integer>();
        int startLine = range.start().line();
        if (startLine == range.end().line()) {
            if (CommentAnalysisUtils.isNotBlank(content)) {
                lineNumbers.add(startLine);
            }
        } else {
            String[] lines2 = content.split("\r\n|\n|\r", -1);
            for (int i2 = 0; i2 < lines2.length; ++i2) {
                if (!CommentAnalysisUtils.isNotBlank(lines2[i2])) continue;
                lineNumbers.add(startLine + i2);
            }
        }
        return lineNumbers;
    }

    private static boolean isNotBlank(String line) {
        for (int i2 = 0; i2 < line.length(); ++i2) {
            char ch = line.charAt(i2);
            if (ch < IS_NON_BLANK_CHAR_IN_COMMENTS.length && !IS_NON_BLANK_CHAR_IN_COMMENTS[ch]) continue;
            return true;
        }
        return false;
    }

    static {
        for (int c = 0; c < IS_NON_BLANK_CHAR_IN_COMMENTS.length; ++c) {
            CommentAnalysisUtils.IS_NON_BLANK_CHAR_IN_COMMENTS[c] = c > 32 && "*#-=|".indexOf(c) == -1;
        }
    }
}

