/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.persistence.conversion;

import java.util.NoSuchElementException;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonarsource.slang.api.TextPointer;
import org.sonarsource.slang.api.TextRange;
import org.sonarsource.slang.api.Token;
import org.sonarsource.slang.api.Tree;
import org.sonarsource.slang.api.TreeMetaData;
import org.sonarsource.slang.impl.TextRangeImpl;
import org.sonarsource.slang.impl.TreeMetaDataProvider;

public final class RangeConverter {
    private RangeConverter() {
    }

    @Nullable
    public static String format(@Nullable TextRange range) {
        if (range == null) {
            return null;
        }
        TextPointer start2 = range.start();
        TextPointer end2 = range.end();
        String endLine = start2.line() == end2.line() ? "" : Integer.toString(end2.line());
        return start2.line() + ":" + start2.lineOffset() + ":" + endLine + ":" + end2.lineOffset();
    }

    @Nullable
    public static TextRange parse(@Nullable String value2) {
        if (value2 == null) {
            return null;
        }
        String[] values2 = value2.split(":", 4);
        if (values2.length != 4) {
            throw new IllegalArgumentException("Invalid TextRange '" + value2 + "'");
        }
        int startLine = Integer.parseInt(values2[0]);
        int startLineOffset = Integer.parseInt(values2[1]);
        int endLine = values2[2].isEmpty() ? startLine : Integer.parseInt(values2[2]);
        int endLineOffset = Integer.parseInt(values2[3]);
        return new TextRangeImpl(startLine, startLineOffset, endLine, endLineOffset);
    }

    @Nullable
    public static String tokenReference(@Nullable Token token) {
        if (token == null) {
            return null;
        }
        return RangeConverter.format(token.textRange());
    }

    @Nullable
    public static Token resolveToken(TreeMetaDataProvider metaDataProvider, @Nullable String tokenReference) {
        TextRange range = RangeConverter.parse(tokenReference);
        if (range == null) {
            return null;
        }
        return metaDataProvider.firstToken(range).orElseThrow(() -> new NoSuchElementException("Token not found: " + tokenReference));
    }

    public static String metaDataReference(Tree tree) {
        return RangeConverter.format(tree.metaData().textRange());
    }

    public static TreeMetaData resolveMetaData(TreeMetaDataProvider metaDataProvider, String metaDataReference) {
        return metaDataProvider.metaData(RangeConverter.parse(metaDataReference));
    }

    @Nullable
    public static String treeReference(@Nullable Tree tree) {
        if (tree == null) {
            return null;
        }
        return RangeConverter.format(tree.metaData().textRange());
    }

    @Nullable
    public static <T extends Tree> T resolveNullableTree(Tree parent, @Nullable String treeReference, Class<T> childClass) {
        if (treeReference == null) {
            return null;
        }
        TextRange range = RangeConverter.parse(treeReference);
        return (T)((Tree)Stream.concat(Stream.of(parent), parent.descendants()).filter(child -> child.textRange().equals(range)).filter(childClass::isInstance).map(childClass::cast).findFirst().orElse(null));
    }
}

