/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.sonarsource.slang.api.Annotation;
import org.sonarsource.slang.api.Comment;
import org.sonarsource.slang.api.HasTextRange;
import org.sonarsource.slang.api.TextPointer;
import org.sonarsource.slang.api.TextRange;
import org.sonarsource.slang.api.Token;
import org.sonarsource.slang.api.TreeMetaData;
import org.sonarsource.slang.impl.TextRangeImpl;
import org.sonarsource.slang.impl.TokenImpl;

public class TreeMetaDataProvider {
    public static final Comparator<HasTextRange> COMPARATOR = Comparator.comparing(e -> e.textRange().start());
    private final List<Comment> sortedComments;
    private final List<Annotation> sortedAnnotations;
    private final List<Token> sortedTokens;

    public TreeMetaDataProvider(List<Comment> comments, List<Token> tokens) {
        this(comments, tokens, Collections.emptyList());
    }

    public TreeMetaDataProvider(List<Comment> comments, List<Token> tokens, List<Annotation> annotations) {
        this.sortedComments = new ArrayList<Comment>(comments);
        this.sortedComments.sort(COMPARATOR);
        this.sortedTokens = new ArrayList<Token>(tokens);
        this.sortedTokens.sort(COMPARATOR);
        this.sortedAnnotations = new ArrayList<Annotation>(annotations);
        this.sortedAnnotations.sort(COMPARATOR);
    }

    public List<Comment> allComments() {
        return this.sortedComments;
    }

    public List<Token> allTokens() {
        return this.sortedTokens;
    }

    public int indexOfFirstToken(TextRange textRange) {
        return TreeMetaDataProvider.indexOfFirstElement(this.sortedTokens, textRange);
    }

    public Optional<Token> firstToken(TextRange textRange) {
        int textRangeIndex = TreeMetaDataProvider.indexOfFirstElement(this.sortedTokens, textRange);
        if (textRangeIndex == -1) {
            return Optional.empty();
        }
        return Optional.of(this.sortedTokens.get(textRangeIndex));
    }

    public Optional<Token> previousToken(TextRange textRange) {
        int textRangeIndex = TreeMetaDataProvider.indexOfFirstElement(this.sortedTokens, textRange);
        if (textRangeIndex <= 0) {
            return Optional.empty();
        }
        return Optional.of(this.sortedTokens.get(textRangeIndex - 1));
    }

    public Optional<Token> previousToken(TextRange textRange, String expectedTokenValue) {
        return this.previousToken(textRange, (Token token) -> expectedTokenValue.equals(token.text()));
    }

    public Optional<Token> previousToken(TextRange textRange, Predicate<Token> expectedConditionToMatch) {
        return this.previousToken(textRange).filter(expectedConditionToMatch::test);
    }

    public void updateTokenType(Token token, Token.Type newType) {
        int tokenIndex = this.indexOfFirstToken(token.textRange());
        if (!this.isExistingToken(token, tokenIndex)) {
            throw new IllegalArgumentException("token '" + token.text() + "' not found in metadata, " + String.valueOf(token.textRange()));
        }
        this.sortedTokens.set(tokenIndex, new TokenImpl(token.textRange(), token.text(), newType));
    }

    private boolean isExistingToken(Token token, int tokenIndex) {
        return tokenIndex != -1 && this.sortedTokens.get(tokenIndex) == token;
    }

    public Token keyword(TextRange textRange) {
        List<Token> keywordsInRange = TreeMetaDataProvider.getElementsInRange(this.sortedTokens, textRange).stream().filter(t -> t.type() == Token.Type.KEYWORD).toList();
        if (keywordsInRange.size() != 1) {
            throw new IllegalArgumentException("Cannot find single keyword in " + String.valueOf(textRange));
        }
        return keywordsInRange.get(0);
    }

    private static <T extends HasTextRange> int indexOfFirstElement(List<T> sortedList, TextRange textRange) {
        HasTextRange key2 = () -> textRange;
        int index2 = Collections.binarySearch(sortedList, key2, COMPARATOR);
        if (index2 < 0) {
            index2 = -index2 - 1;
        }
        if (index2 < sortedList.size() && ((HasTextRange)sortedList.get(index2)).textRange().isInside(textRange)) {
            return index2;
        }
        return -1;
    }

    private static <T extends HasTextRange> List<T> getElementsInRange(List<T> sortedList, TextRange textRange) {
        HasTextRange element;
        int first2 = TreeMetaDataProvider.indexOfFirstElement(sortedList, textRange);
        if (first2 == -1) {
            return Collections.emptyList();
        }
        ArrayList<HasTextRange> elementsInsideRange = new ArrayList<HasTextRange>();
        for (int i2 = first2; i2 < sortedList.size() && (element = (HasTextRange)sortedList.get(i2)).textRange().isInside(textRange); ++i2) {
            elementsInsideRange.add(element);
        }
        return elementsInsideRange;
    }

    private static List<Annotation> getAnnotationStartingAtRange(List<Annotation> sortedList, List<Token> sortedToken, TextRange textRange) {
        Annotation currentAnnotation;
        int first2 = TreeMetaDataProvider.indexOfFirstElement(sortedList, textRange);
        if (first2 == -1) {
            return Collections.emptyList();
        }
        ArrayList<Annotation> elementsInsideRange = new ArrayList<Annotation>();
        TextPointer currentPointer = textRange.start();
        for (int i2 = first2; i2 < sortedList.size() && (currentAnnotation = sortedList.get(i2)).textRange().start().equals(currentPointer); ++i2) {
            elementsInsideRange.add(currentAnnotation);
            int nextAnnotation = TreeMetaDataProvider.indexOfFirstElement(sortedToken, new TextRangeImpl(currentAnnotation.textRange().end(), textRange.end()));
            if (nextAnnotation < 0) break;
            currentPointer = sortedToken.get(nextAnnotation).textRange().start();
        }
        return elementsInsideRange;
    }

    public TreeMetaData metaData(TextRange textRange) {
        return new TreeMetaDataImpl(textRange);
    }

    private class TreeMetaDataImpl
    implements TreeMetaData {
        private final TextRange textRange;
        private Set<Integer> linesOfCode;
        private List<Annotation> annotations;

        private TreeMetaDataImpl(TextRange textRange) {
            this.textRange = textRange;
        }

        @Override
        public TextRange textRange() {
            return this.textRange;
        }

        @Override
        public List<Comment> commentsInside() {
            return TreeMetaDataProvider.getElementsInRange(TreeMetaDataProvider.this.sortedComments, this.textRange);
        }

        @Override
        public List<Annotation> annotations() {
            if (this.annotations == null) {
                this.annotations = TreeMetaDataProvider.getAnnotationStartingAtRange(TreeMetaDataProvider.this.sortedAnnotations, TreeMetaDataProvider.this.sortedTokens, this.textRange);
            }
            return this.annotations;
        }

        @Override
        public List<Token> tokens() {
            return TreeMetaDataProvider.getElementsInRange(TreeMetaDataProvider.this.sortedTokens, this.textRange);
        }

        @Override
        public Set<Integer> linesOfCode() {
            if (this.linesOfCode == null) {
                this.linesOfCode = this.computeLinesOfCode();
            }
            return this.linesOfCode;
        }

        private Set<Integer> computeLinesOfCode() {
            HashSet<Integer> loc = new HashSet<Integer>();
            for (Token token : this.tokens()) {
                TextRange range = token.textRange();
                for (int i2 = range.start().line(); i2 <= range.end().line(); ++i2) {
                    loc.add(i2);
                }
            }
            return loc;
        }
    }
}

