/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.checks.utils;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.sonarsource.slang.api.FunctionDeclarationTree;
import org.sonarsource.slang.api.FunctionInvocationTree;
import org.sonarsource.slang.api.IdentifierTree;
import org.sonarsource.slang.api.MemberSelectTree;
import org.sonarsource.slang.api.ModifierTree;
import org.sonarsource.slang.api.StringLiteralTree;
import org.sonarsource.slang.api.Tree;
import org.sonarsource.slang.checks.utils.ExpressionUtils;

public class FunctionUtils {
    private FunctionUtils() {
    }

    public static boolean isPrivateMethod(FunctionDeclarationTree method2) {
        return FunctionUtils.hasModifierMethod(method2, ModifierTree.Kind.PRIVATE);
    }

    public static boolean isOverrideMethod(FunctionDeclarationTree method2) {
        return FunctionUtils.hasModifierMethod(method2, ModifierTree.Kind.OVERRIDE);
    }

    public static boolean hasModifierMethod(FunctionDeclarationTree method2, ModifierTree.Kind kind) {
        return method2.modifiers().stream().filter(ModifierTree.class::isInstance).map(ModifierTree.class::cast).anyMatch(modifier -> modifier.kind() == kind);
    }

    public static boolean hasFunctionCallNameIgnoreCase(FunctionInvocationTree tree, String name2) {
        return FunctionUtils.getFunctionInvocationName(tree).filter(name2::equalsIgnoreCase).isPresent();
    }

    public static Set<String> getStringsTokens(FunctionDeclarationTree functionDeclarationTree, String delimitersRegex) {
        HashSet<String> stringLiteralTokens = new HashSet<String>();
        functionDeclarationTree.descendants().filter(StringLiteralTree.class::isInstance).map(StringLiteralTree.class::cast).map(StringLiteralTree::content).forEach(literal -> stringLiteralTokens.addAll(Arrays.asList(literal.split(delimitersRegex))));
        return stringLiteralTokens;
    }

    private static Optional<String> getFunctionInvocationName(FunctionInvocationTree tree) {
        return ExpressionUtils.getMemberSelectOrIdentifierName(tree.memberSelect());
    }

    public static boolean hasFunctionCallFullNameIgnoreCase(FunctionInvocationTree tree, String ... names2) {
        return FunctionUtils.hasFunctionCallFullNameIgnoreCaseHelper(tree.memberSelect(), Arrays.asList(names2));
    }

    private static boolean hasFunctionCallFullNameIgnoreCaseHelper(Tree tree, List<String> names2) {
        if (tree instanceof IdentifierTree) {
            return names2.size() == 1 && ((IdentifierTree)tree).name().equalsIgnoreCase(names2.get(0));
        }
        if (tree instanceof MemberSelectTree) {
            MemberSelectTree memberSelectTree = (MemberSelectTree)tree;
            return names2.size() > 1 && memberSelectTree.identifier().name().equalsIgnoreCase(names2.get(names2.size() - 1)) && FunctionUtils.hasFunctionCallFullNameIgnoreCaseHelper(memberSelectTree.expression(), FunctionUtils.dropLastElement(names2));
        }
        return false;
    }

    private static List<String> dropLastElement(List<String> list2) {
        return list2.subList(0, list2.size() - 1);
    }
}

