/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.checks;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.check.Rule;
import org.sonarsource.slang.api.ClassDeclarationTree;
import org.sonarsource.slang.api.FunctionDeclarationTree;
import org.sonarsource.slang.api.IdentifierTree;
import org.sonarsource.slang.api.Tree;
import org.sonarsource.slang.checks.api.CheckContext;
import org.sonarsource.slang.checks.api.InitContext;
import org.sonarsource.slang.checks.api.SlangCheck;
import org.sonarsource.slang.checks.utils.FunctionUtils;
import org.sonarsource.slang.utils.SyntacticEquivalence;

@Rule(key="S1144")
public class UnusedPrivateMethodCheck
implements SlangCheck {
    @Override
    public void initialize(InitContext init) {
        init.register(ClassDeclarationTree.class, this::processClassDeclaration);
    }

    protected void processClassDeclaration(CheckContext context, ClassDeclarationTree classDeclarationTree) {
        if (context.ancestors().stream().noneMatch(ClassDeclarationTree.class::isInstance)) {
            this.reportUnusedPrivateMethods(context, classDeclarationTree);
        }
    }

    protected void reportUnusedPrivateMethods(CheckContext context, ClassDeclarationTree classDeclarationTree) {
        MethodAndIdentifierCollector methodAndIdentifierCollector = new MethodAndIdentifierCollector(classDeclarationTree.descendants());
        methodAndIdentifierCollector.getMethodDeclarations().stream().filter(this::isValidPrivateMethod).forEach(tree -> {
            IdentifierTree identifier = tree.name();
            if (identifier != null && this.isUnusedMethod(identifier, methodAndIdentifierCollector.getUsedUniqueIdentifiers())) {
                String message2 = String.format("Remove this unused private \"%s\" method.", identifier.name());
                context.reportIssue(tree.rangeToHighlight(), message2);
            }
        });
    }

    protected boolean isValidPrivateMethod(FunctionDeclarationTree method2) {
        return FunctionUtils.isPrivateMethod(method2) && !FunctionUtils.isOverrideMethod(method2);
    }

    protected boolean isUnusedMethod(IdentifierTree identifier, Set<String> usedIdentifierNames) {
        return !usedIdentifierNames.contains(SyntacticEquivalence.getUniqueIdentifier(identifier));
    }

    protected static class MethodAndIdentifierCollector {
        private Set<FunctionDeclarationTree> methodDeclarations = new HashSet<FunctionDeclarationTree>();
        private Set<String> usedUniqueIdentifiers;

        Set<FunctionDeclarationTree> getMethodDeclarations() {
            return this.methodDeclarations;
        }

        public Set<String> getUsedUniqueIdentifiers() {
            return this.usedUniqueIdentifiers;
        }

        public MethodAndIdentifierCollector(Stream<Tree> descendants) {
            HashSet usedIdentifiers = new HashSet();
            descendants.forEach(tree -> {
                if (tree instanceof FunctionDeclarationTree && !((FunctionDeclarationTree)tree).isConstructor()) {
                    this.methodDeclarations.add((FunctionDeclarationTree)tree);
                } else if (tree instanceof IdentifierTree) {
                    usedIdentifiers.add((IdentifierTree)tree);
                }
            });
            usedIdentifiers.removeAll(this.methodDeclarations.stream().map(FunctionDeclarationTree::name).collect(Collectors.toSet()));
            this.usedUniqueIdentifiers = usedIdentifiers.stream().filter(Objects::nonNull).map(SyntacticEquivalence::getUniqueIdentifier).collect(Collectors.toCollection(HashSet::new));
        }
    }
}

