/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.checks;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonarsource.slang.api.AssignmentExpressionTree;
import org.sonarsource.slang.api.HasTextRange;
import org.sonarsource.slang.api.StringLiteralTree;
import org.sonarsource.slang.api.Tree;
import org.sonarsource.slang.api.VariableDeclarationTree;
import org.sonarsource.slang.checks.api.CheckContext;
import org.sonarsource.slang.checks.api.InitContext;
import org.sonarsource.slang.checks.api.SlangCheck;
import org.sonarsource.slang.checks.utils.ExpressionUtils;

@Rule(key="S2068")
public class HardcodedCredentialsCheck
implements SlangCheck {
    private static final String DEFAULT_VALUE = "password,passwd,pwd,passphrase";
    private static final Pattern URI_PREFIX = Pattern.compile("^\\w{1,8}://");
    @RuleProperty(key="credentialWords", description="Comma separated list of words identifying potential credentials", defaultValue="password,passwd,pwd,passphrase")
    public String credentialWords = "password,passwd,pwd,passphrase";
    private List<Pattern> variablePatterns;
    private List<Pattern> literalPatterns;

    @Override
    public void initialize(InitContext init) {
        init.register(AssignmentExpressionTree.class, (ctx, tree) -> {
            Tree leftHandSide = tree.leftHandSide();
            ExpressionUtils.getMemberSelectOrIdentifierName(leftHandSide).ifPresent(variableName -> this.checkVariable((CheckContext)ctx, leftHandSide, (String)variableName, tree.statementOrExpression()));
        });
        init.register(VariableDeclarationTree.class, (ctx, tree) -> this.checkVariable((CheckContext)ctx, tree.identifier(), tree.identifier().name(), tree.initializer()));
        init.register(StringLiteralTree.class, (ctx, tree) -> {
            String content = tree.content();
            if (HardcodedCredentialsCheck.isURIWithCredentials(content)) {
                ctx.reportIssue((HasTextRange)tree, "Review this hard-coded URL, which may contain a credential.");
            } else {
                this.literalPatterns().map(pattern -> pattern.matcher(content)).filter(Matcher::find).map(matcher -> matcher.group(1)).filter(match2 -> !HardcodedCredentialsCheck.isQuery(content, match2)).forEach(credential -> HardcodedCredentialsCheck.report(ctx, tree, credential));
            }
        });
    }

    private static boolean isURIWithCredentials(String stringLiteral) {
        if (URI_PREFIX.matcher(stringLiteral).find()) {
            try {
                String userInfo = new URI(stringLiteral).getUserInfo();
                if (userInfo != null) {
                    String[] parts = userInfo.split(":");
                    return parts.length > 1 && !parts[0].equals(parts[1]);
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return false;
    }

    private static boolean isNotEmptyString(@Nullable Tree tree) {
        return tree instanceof StringLiteralTree && !((StringLiteralTree)tree).content().isEmpty();
    }

    private static boolean isQuery(String value2, String match2) {
        String followingString = value2.substring(value2.indexOf(match2) + match2.length());
        return followingString.startsWith("=?") || followingString.startsWith("=%") || followingString.startsWith("=:") || followingString.startsWith("={") || followingString.equals("='");
    }

    private static void report(CheckContext ctx, Tree tree, String matchName) {
        String message2 = String.format("\"%s\" detected here, make sure this is not a hard-coded credential.", matchName);
        ctx.reportIssue(tree, message2);
    }

    private void checkVariable(CheckContext ctx, Tree variable, String variableName, @Nullable Tree value2) {
        if (HardcodedCredentialsCheck.isNotEmptyString(value2)) {
            this.variablePatterns().map(pattern -> pattern.matcher(variableName)).filter(Matcher::find).forEach(matcher -> HardcodedCredentialsCheck.checkAssignedValue(ctx, matcher, variable, ((StringLiteralTree)value2).value()));
        }
    }

    private static void checkAssignedValue(CheckContext ctx, Matcher matcher, Tree leftHand, String value2) {
        if (!matcher.pattern().matcher(value2).find()) {
            HardcodedCredentialsCheck.report(ctx, leftHand, matcher.group(1));
        }
    }

    private Stream<Pattern> variablePatterns() {
        if (this.variablePatterns == null) {
            this.variablePatterns = this.toPatterns("");
        }
        return this.variablePatterns.stream();
    }

    private Stream<Pattern> literalPatterns() {
        if (this.literalPatterns == null) {
            this.literalPatterns = this.toPatterns("=\\S");
        }
        return this.literalPatterns.stream();
    }

    private List<Pattern> toPatterns(String suffix) {
        return Stream.of(this.credentialWords.split(",")).map(String::trim).map(word -> Pattern.compile("(" + word + ")" + suffix, 2)).toList();
    }
}

